/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import net.minecraftforge.fluids.Fluid;

public class UndergroundFluidChunkLocation
implements ILocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private final int offsetX;
    private final int offsetZ;
    private final UndergroundFluidPosition undergroundFluid;

    public UndergroundFluidChunkLocation(int chunkX, int chunkZ, int dimensionId, UndergroundFluidPosition fluid, int offsetX, int offsetZ) {
        this.blockX = Utils.coordChunkToBlock(chunkX + offsetX);
        this.blockZ = Utils.coordChunkToBlock(chunkZ + offsetZ);
        this.dimensionId = dimensionId;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.undergroundFluid = fluid;
    }

    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getFluidAmountFormatted() {
        if (this.getFluidAmount() >= 1000) {
            return this.getFluidAmount() / 1000 + "kL";
        }
        return this.getFluidAmount() + "L";
    }

    public int getFluidAmount() {
        return this.undergroundFluid.chunks[this.offsetX][this.offsetZ];
    }

    public Fluid getFluid() {
        return this.undergroundFluid.fluid;
    }

    public int getMaxAmountInField() {
        return this.undergroundFluid.getMaxProduction();
    }

    public int getMinAmountInField() {
        return this.undergroundFluid.getMinProduction();
    }
}

