/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.config.SecurityPermissions;
import appeng.api.parts.PartItemStack;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.utils.EffectiveSide;

public abstract class ThERotateablePart
extends ThEPartBase {
    private static final String NBT_KEY_ROT_DIR = "partRotation";
    private byte renderRotation = 0;

    public ThERotateablePart(AEPartsEnum associatedPart, SecurityPermissions ... interactionPermissions) {
        super(associatedPart, interactionPermissions);
    }

    protected void rotateRenderer(RenderBlocks renderer, boolean reset) {
        byte rot;
        byte by = rot = reset ? (byte)0 : this.renderRotation;
        renderer.field_147873_r = by;
        renderer.field_147867_u = by;
        renderer.field_147871_s = by;
        renderer.field_147869_t = by;
        renderer.field_147875_q = by;
        renderer.field_147865_v = by;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        TileEntity hte = this.getHostTile();
        if (!player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)hte.field_145851_c, (int)hte.field_145848_d, (int)hte.field_145849_e)) {
            if (EffectiveSide.isServerSide()) {
                if (this.renderRotation > 3 || this.renderRotation < 0) {
                    this.renderRotation = 0;
                }
                switch (this.renderRotation) {
                    case 0: {
                        this.renderRotation = 1;
                        break;
                    }
                    case 1: {
                        this.renderRotation = (byte)3;
                        break;
                    }
                    case 2: {
                        this.renderRotation = 0;
                        break;
                    }
                    case 3: {
                        this.renderRotation = (byte)2;
                    }
                }
                this.markForUpdate();
                this.markForSave();
            }
            return true;
        }
        return super.onActivate(player, position);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_ROT_DIR)) {
            this.renderRotation = data.func_74771_c(NBT_KEY_ROT_DIR);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean redraw = false;
        redraw |= super.readFromStream(stream);
        byte streamRot = stream.readByte();
        if (this.renderRotation != streamRot) {
            this.renderRotation = streamRot;
            redraw |= true;
        }
        return redraw;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType == PartItemStack.World && this.renderRotation != 0) {
            data.func_74774_a(NBT_KEY_ROT_DIR, this.renderRotation);
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeByte((int)this.renderRotation);
    }
}

