/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.server.ThEServerPacket;

public class Packet_S_EssentiaCellTerminal
extends ThEServerPacket {
    private static final byte MODE_SELECTED_ASPECT = 0;
    private static final byte MODE_FULL_UPDATE = 1;
    private static final byte MODE_SORT_CHANGE = 2;
    private static final byte MODE_AUTO_CRAFT = 3;
    private static final byte MODE_VIEW_CHANGE = 4;
    private static final byte MODE_HELD_ITEM = 5;
    private static final byte MODE_REQUEST_CRAFTING_STATUS = 6;
    private Aspect selectedAspect;
    private Boolean flag;

    private static Packet_S_EssentiaCellTerminal newPacket(EntityPlayer player, byte mode) {
        Packet_S_EssentiaCellTerminal packet = new Packet_S_EssentiaCellTerminal();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendAutoCraft(EntityPlayer player, Aspect aspect) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)3);
        packet.selectedAspect = aspect;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendChangeSorting(EntityPlayer player, boolean wasRightClick) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)2);
        packet.flag = wasRightClick;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendChangeView(EntityPlayer player, boolean wasRightClick) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)4);
        packet.flag = wasRightClick;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendFullUpdateRequest(EntityPlayer player) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)1);
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendInteractWithHeldItem(EntityPlayer player, Aspect aspect) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)5);
        packet.selectedAspect = aspect;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendSelectedAspect(EntityPlayer player, Aspect currentAspect) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)0);
        packet.selectedAspect = currentAspect;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendOpenCraftingStatus(EntityPlayer player) {
        Packet_S_EssentiaCellTerminal packet = Packet_S_EssentiaCellTerminal.newPacket(player, (byte)6);
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        if (this.player == null || !(this.player.field_71070_bA instanceof ContainerEssentiaCellTerminalBase)) {
            return;
        }
        switch (this.mode) {
            case 0: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onReceivedSelectedAspect(this.selectedAspect);
                break;
            }
            case 1: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onClientRequestFullUpdate();
                break;
            }
            case 2: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onClientRequestSortModeChange(this.player, this.flag);
                break;
            }
            case 3: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onClientRequestAutoCraft(this.player, this.selectedAspect);
                break;
            }
            case 4: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onClientRequestViewModeChange(this.player, this.flag);
                break;
            }
            case 5: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onInteractWithHeldItem(this.player, this.selectedAspect);
                break;
            }
            case 6: {
                ((ContainerEssentiaCellTerminalBase)this.player.field_71070_bA).onClientRequestCraftingStatus(this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: 
            case 3: 
            case 5: {
                this.selectedAspect = ThEBasePacket.readAspect(stream);
                break;
            }
            case 2: 
            case 4: {
                this.flag = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: 
            case 3: 
            case 5: {
                ThEBasePacket.writeAspect(this.selectedAspect, stream);
                break;
            }
            case 2: 
            case 4: {
                stream.writeBoolean(this.flag.booleanValue());
            }
        }
    }
}

