/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumicenergistics.api.entities.IGolemHookHandler;
import thaumicenergistics.api.entities.IGolemHookSyncRegistry;
import thaumicenergistics.common.integration.tc.GolemSyncRegistry;
import thaumicenergistics.common.utils.EffectiveSide;
import thaumicenergistics.common.utils.ThELog;
import thaumicenergistics.fml.ThECore;

public class GolemHooks {
    private static int DATAWATCHER_ID = -1;
    private static final GolemSyncRegistry defaultSyncRegistry = new GolemSyncRegistry();
    private static final DummyHookHandler internalHandler = new DummyHookHandler();
    protected static final HashSet<IGolemHookHandler> registeredHandlers = new HashSet();
    protected static final HashSet<IGolemHookHandler> dynamicHandlers = new HashSet();
    protected static final HashSet<IGolemHookHandler> renderHandlers = new HashSet();

    private static void logCaughtException(String hook, IGolemHookHandler handler, Exception e) {
        if (handler != null) {
            if (e != null) {
                ThELog.warning("Caught Exception During call to '" + hook + "' for handler '%s':", handler.getClass().getCanonicalName());
                ThELog.warning(e.toString(), new Object[0]);
            } else {
                ThELog.warning("Caught Unknown Exception During call to '" + hook + "' for handler '%s'", handler.getClass().getCanonicalName());
            }
        } else if (e != null) {
            ThELog.warning("Caught Exception During call to null handler '" + hook + "':", new Object[0]);
            ThELog.warning(e.toString(), new Object[0]);
        } else {
            ThELog.warning("Caught Unknown Exception During call to null handler '" + hook + "'", new Object[0]);
        }
    }

    public static void hook_Bell_OnLeftClickGolem(EntityGolemBase golem, ItemStack dropped, EntityPlayer player, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        boolean dismantled = player.func_70093_af();
        Side side = EffectiveSide.side();
        for (IGolemHookHandler handler : registeredHandlers) {
            try {
                Object handlerData = golemHandlerData.getOrDefault(handler, null);
                handler.bellLeftClicked(golem, handlerData, dropped, player, dismantled, side);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("onBellLeftClick", handler, e);
            }
        }
    }

    public static boolean hook_CustomInteraction(EntityGolemBase golem, EntityPlayer player, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        GolemSyncRegistry syncRegistry = (GolemSyncRegistry)golemHandlerData.get(internalHandler);
        boolean needsSync = false;
        boolean needsSetup = false;
        boolean skipGUI = false;
        Side side = EffectiveSide.side();
        block10: for (IGolemHookHandler handler : registeredHandlers) {
            IGolemHookHandler.InteractionLevel handlerLevel;
            Object handlerData = golemHandlerData.getOrDefault(handler, null);
            try {
                handlerLevel = handler.canHandleInteraction(golem, handlerData, player, side);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("canHandleInteraction", handler, e);
                continue;
            }
            switch (handlerLevel) {
                case NoInteraction: {
                    continue block10;
                }
                case BasicInteraction: {
                    break;
                }
                case SyncInteraction: {
                    needsSync = true;
                    break;
                }
                case FullInteraction: {
                    needsSync = true;
                    needsSetup = true;
                }
            }
            skipGUI = true;
            boolean hadData = handlerData != null;
            try {
                handlerData = handler.customInteraction(golem, handlerData, syncRegistry, player, side);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("customInteraction", handler, e);
                continue;
            }
            if (handlerData == null) {
                if (!hadData) continue;
                golemHandlerData.remove(handler);
                continue;
            }
            golemHandlerData.put(handler, handlerData);
        }
        if (side == Side.SERVER) {
            if (needsSetup) {
                golem.setupGolem();
            }
            if (needsSync) {
                syncRegistry.markDirty();
            }
        }
        return skipGUI;
    }

    public static void hook_EntityInit(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        GolemSyncRegistry localRegistry = new GolemSyncRegistry();
        localRegistry.copyDefaults(defaultSyncRegistry);
        golemHandlerData.put(internalHandler, localRegistry);
        DataWatcher watcher = golem.func_70096_w();
        if (DATAWATCHER_ID == -1) {
            for (int i = 4; i < 31; ++i) {
                try {
                    watcher.func_75682_a(DATAWATCHER_ID, (Object)localRegistry.mappingsToString());
                    DATAWATCHER_ID = i;
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            DATAWATCHER_ID = -2;
            ThELog.warning("Golem Hook API is unable to register channel for sync data.", new Object[0]);
            return;
        }
        if (DATAWATCHER_ID > 0) {
            try {
                watcher.func_75682_a(DATAWATCHER_ID, (Object)localRegistry.mappingsToString());
            }
            catch (Exception e) {
                localRegistry.markDirty();
            }
        }
    }

    public static void hook_onEntityUpdate(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        GolemSyncRegistry syncRegistry = (GolemSyncRegistry)golemHandlerData.get(internalHandler);
        if (EffectiveSide.isServerSide()) {
            for (IGolemHookHandler handler : dynamicHandlers) {
                try {
                    handler.golemTick(golem, golemHandlerData.get(handler), syncRegistry);
                }
                catch (Exception e) {
                    GolemHooks.logCaughtException("golemTick", handler, e);
                }
            }
            if (syncRegistry.hasChanged() && DATAWATCHER_ID > 0) {
                try {
                    golem.func_70096_w().func_75692_b(DATAWATCHER_ID, (Object)syncRegistry.mappingsToString());
                }
                catch (NullPointerException e1) {
                    try {
                        golem.func_70096_w().func_75682_a(DATAWATCHER_ID, (Object)syncRegistry.mappingsToString());
                    }
                    catch (Exception e2) {
                        syncRegistry.markDirty();
                    }
                }
            }
            return;
        }
        if (DATAWATCHER_ID < 0) {
            return;
        }
        syncRegistry.clientSyncTicks += 1.0f;
        if (syncRegistry.clientSyncTicks >= 30.0f) {
            String watcherString;
            syncRegistry.clientSyncTicks = 0.0f;
            try {
                watcherString = golem.func_70096_w().func_75681_e(DATAWATCHER_ID);
                if (!syncRegistry.hasChanged() && watcherString == syncRegistry.lastUpdatedFrom) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            HashSet<IGolemHookHandler> handlersToUpdate = syncRegistry.readFromString(watcherString);
            if (handlersToUpdate == null) {
                return;
            }
            for (IGolemHookHandler handler : handlersToUpdate) {
                Object handlerData = golemHandlerData.getOrDefault(handler, null);
                boolean hadData = handlerData != null;
                try {
                    handlerData = handler.syncDataChanged(syncRegistry, handlerData);
                }
                catch (Exception e) {
                    GolemHooks.logCaughtException("onSyncDataChanged", handler, e);
                    continue;
                }
                if (handlerData == null) {
                    if (!hadData) continue;
                    golemHandlerData.remove(handler);
                    continue;
                }
                golemHandlerData.put(handler, handlerData);
            }
        }
    }

    public static void hook_Placer_SpawnGolem(EntityGolemBase golem, ItemStack itemGolemPlacer, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        if (!itemGolemPlacer.func_77942_o()) {
            return;
        }
        Side side = EffectiveSide.side();
        for (IGolemHookHandler handler : registeredHandlers) {
            try {
                Object handlerData = handler.spawnGolemFromItemStack(golem, itemGolemPlacer, side);
                if (handlerData == null) continue;
                golemHandlerData.put(handler, handlerData);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("spawnGolemFromItemStack", handler, e);
            }
        }
    }

    public static void hook_ReadEntityFromNBT(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData, NBTTagCompound nbt) {
        for (IGolemHookHandler handler : registeredHandlers) {
            try {
                Object handlerData = golemHandlerData.getOrDefault(handler, null);
                handlerData = handler.readEntityFromNBT(golem, nbt);
                if (handlerData == null) {
                    golemHandlerData.remove(handler);
                    continue;
                }
                golemHandlerData.put(handler, handlerData);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("readEntityFromNBT", handler, e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void hook_RenderGolem(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData, double x, double y, double z, float partialElaspsedTick) {
        for (IGolemHookHandler handler : renderHandlers) {
            try {
                handler.renderGolem(golem, golemHandlerData.get(handler), x, y, z, partialElaspsedTick);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("renderGolem", handler, e);
            }
        }
    }

    public static void hook_SetupGolem(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData) {
        GolemSyncRegistry localRegistry = (GolemSyncRegistry)golemHandlerData.get(internalHandler);
        Side side = EffectiveSide.side();
        for (IGolemHookHandler handler : registeredHandlers) {
            try {
                Object handlerData = golemHandlerData.getOrDefault(handler, null);
                boolean hadData = handlerData != null;
                handlerData = handler.setupGolem(golem, handlerData, localRegistry, side);
                if (handlerData == null) {
                    if (!hadData) continue;
                    golemHandlerData.remove(handler);
                    continue;
                }
                golemHandlerData.put(handler, handlerData);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("setupGolem", handler, e);
            }
        }
        if (localRegistry.hasChanged() && side == Side.SERVER && DATAWATCHER_ID > 0) {
            try {
                golem.func_70096_w().func_75692_b(DATAWATCHER_ID, (Object)localRegistry.mappingsToString());
            }
            catch (NullPointerException e) {
                localRegistry.markDirty();
            }
        }
    }

    public static void hook_WriteEntityToNBT(EntityGolemBase golem, HashMap<IGolemHookHandler, Object> golemHandlerData, NBTTagCompound nbt) {
        for (IGolemHookHandler handler : registeredHandlers) {
            try {
                Object handlerData = golemHandlerData.getOrDefault(handler, null);
                handler.writeEntityNBT(golem, handlerData, nbt);
            }
            catch (Exception e) {
                GolemHooks.logCaughtException("writeEntityNBT", handler, e);
            }
        }
    }

    public static void registerHandler(@Nonnull IGolemHookHandler handler) {
        if (ThECore.golemHooksTransformFailed) {
            return;
        }
        try {
            registeredHandlers.add(handler);
            if (handler.needsRenderer()) {
                renderHandlers.add(handler);
            }
            if (handler.needsDynamicUpdates()) {
                dynamicHandlers.add(handler);
            }
            GolemHooks.defaultSyncRegistry.canRegister = true;
            handler.addDefaultSyncEntries(defaultSyncRegistry);
            GolemHooks.defaultSyncRegistry.canRegister = false;
        }
        catch (Exception e) {
            GolemHooks.logCaughtException("registerHandler", handler, e);
        }
    }

    private static class DummyHookHandler
    implements IGolemHookHandler {
        @Override
        public void addDefaultSyncEntries(IGolemHookSyncRegistry syncRegistry) {
        }

        @Override
        public void bellLeftClicked(EntityGolemBase golem, Object handlerData, ItemStack itemGolemPlacer, EntityPlayer player, boolean dismantled, Side side) {
        }

        @Override
        public IGolemHookHandler.InteractionLevel canHandleInteraction(EntityGolemBase golem, Object handlerData, EntityPlayer player, Side side) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }

        @Override
        public Object customInteraction(EntityGolemBase golem, Object handlerData, IGolemHookSyncRegistry syncData, EntityPlayer player, Side side) {
            return null;
        }

        @Override
        public void golemTick(EntityGolemBase golem, Object serverHandlerData, IGolemHookSyncRegistry syncData) {
        }

        @Override
        public boolean needsDynamicUpdates() {
            return false;
        }

        @Override
        public boolean needsRenderer() {
            return false;
        }

        @Override
        public Object readEntityFromNBT(EntityGolemBase golem, NBTTagCompound nbtTag) {
            return null;
        }

        @Override
        public void renderGolem(EntityGolemBase golem, Object clientHandlerData, double x, double y, double z, float partialElaspsedTick) {
        }

        @Override
        public Object setupGolem(EntityGolemBase golem, Object handlerData, IGolemHookSyncRegistry syncData, Side side) {
            return null;
        }

        @Override
        public Object spawnGolemFromItemStack(EntityGolemBase golem, ItemStack itemGolemPlacer, Side side) {
            return null;
        }

        @Override
        public Object syncDataChanged(IGolemHookSyncRegistry syncData, Object clientHandlerData) {
            return null;
        }

        @Override
        public void writeEntityNBT(EntityGolemBase golem, Object serverHandlerData, NBTTagCompound nbtTag) {
        }
    }
}

