/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.tcinventoryscan.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import net.blay09.mods.tcinventoryscan.CommonProxy;
import net.blay09.mods.tcinventoryscan.TCInventoryScanning;
import net.blay09.mods.tcinventoryscan.net.MessageScanSelf;
import net.blay09.mods.tcinventoryscan.net.MessageScanSlot;
import net.blay09.mods.tcinventoryscan.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanResult;
import thaumcraft.client.lib.ClientTickEventsFML;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ScanManager;

public class ClientProxy
extends CommonProxy {
    private static final int SCAN_TICKS = 50;
    private static final int SOUND_TICKS = 5;
    private static final int INVENTORY_PLAYER_X = 26;
    private static final int INVENTORY_PLAYER_Y = 8;
    private static final int INVENTORY_PLAYER_WIDTH = 52;
    private static final int INVENTORY_PLAYER_HEIGHT = 70;
    private boolean isValidSlot = false;
    private Item thaumometer;
    private Slot hoveringSlot;
    private Slot lastHoveredSlot;
    private int ticksHovered = 0;
    private ClientTickEventsFML effectRenderer;
    private ScanResult currentScan = null;
    private boolean isHoveringOverPlayer;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.effectRenderer = new ClientTickEventsFML();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.thaumometer = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemThaumometer");
    }

    private void simulateScan(EntityPlayer player) {
        ScanResult result = new ScanResult(2, 0, 0, (Entity)player, "");
        if (this.isHoveringOverPlayer && ScanManager.isValidScanTarget((EntityPlayer)player, (ScanResult)result, (String)"@")) {
            this.currentScan = result;
            this.isValidSlot = true;
            return;
        }
        if (this.hoveringSlot != null && this.hoveringSlot.func_75211_c() != null) {
            result = new ScanResult(1, Item.func_150891_b((Item)this.hoveringSlot.func_75211_c().func_77973_b()), this.hoveringSlot.func_75211_c().func_77960_j(), null, "");
            if (this.hoveringSlot.func_82869_a(player) && !(this.hoveringSlot instanceof SlotCrafting) && ScanManager.isValidScanTarget((EntityPlayer)player, (ScanResult)result, (String)"@") && !ScanManager.getScanAspects((ScanResult)result, (World)Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76579_a).aspects.isEmpty()) {
                this.currentScan = result;
                this.isValidSlot = true;
                return;
            }
        }
        this.cancel();
    }

    private boolean notHoldingThaumometer(EntityPlayer player) {
        return player == null || player.field_71071_by.func_70445_o() == null || player.field_71071_by.func_70445_o().func_77973_b() != this.thaumometer;
    }

    private void cancel() {
        this.ticksHovered = 0;
        this.currentScan = null;
        this.isValidSlot = false;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent ignored) {
        if (!TCInventoryScanning.isServerSideInstalled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (this.notHoldingThaumometer((EntityPlayer)player)) {
            this.cancel();
            return;
        }
        if (this.hoveringSlot == this.lastHoveredSlot) {
            if (this.isValidSlot) {
                ++this.ticksHovered;
                this.playScanningSoundTick((EntityPlayer)player);
                if (this.ticksHovered >= 50) {
                    this.tryCompleteScan((EntityPlayer)player);
                }
            } else if (this.isHoveringOverPlayer) {
                this.cancel();
                this.simulateScan((EntityPlayer)player);
            }
        } else {
            this.cancel();
            this.simulateScan((EntityPlayer)player);
        }
        this.lastHoveredSlot = this.hoveringSlot;
    }

    private void tryCompleteScan(EntityPlayer player) {
        try {
            if (ScanManager.completeScan((EntityPlayer)player, (ScanResult)this.currentScan, (String)"@")) {
                NetworkHandler.instance.sendToServer((IMessage)(this.isHoveringOverPlayer ? new MessageScanSelf() : new MessageScanSlot(this.hoveringSlot.field_75222_d)));
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        this.cancel();
    }

    private void playScanningSoundTick(EntityPlayer entityPlayer) {
        if (this.ticksHovered > 5 && this.ticksHovered % 2 == 0) {
            entityPlayer.field_70170_p.func_72980_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, "thaumcraft:cameraticks", 0.2f, 0.45f + entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.1f, false);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (TCInventoryScanning.isServerSideInstalled && event.itemStack.func_77973_b() == this.thaumometer) {
            event.toolTip.add("\u00a76" + I18n.func_135052_a((String)"tcinventoryscan:thaumometerTooltip", (Object[])new Object[0]));
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String[] lines;
                for (String line : lines = I18n.func_135052_a((String)"tcinventoryscan:thaumometerTooltipMore", (Object[])new Object[0]).split("\\\\n")) {
                    event.toolTip.add("\u00a73" + line);
                }
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (TCInventoryScanning.isServerSideInstalled && event.gui instanceof GuiContainer) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (this.notHoldingThaumometer((EntityPlayer)player)) {
                return;
            }
            this.isHoveringOverPlayer = this.isHoveringPlayer((GuiContainer)event.gui, event.mouseX, event.mouseY);
            this.hoveringSlot = ((GuiContainer)event.gui).func_146975_c(event.mouseX, event.mouseY);
            if (this.hoveringSlot == null || this.hoveringSlot.func_75211_c() == null) {
                return;
            }
            if (this.currentScan != null) {
                this.renderScanningProgress(event.gui, event.mouseX, event.mouseY, (float)this.ticksHovered / 50.0f);
            } else if (!this.isHoveringOverPlayer) {
                event.gui.func_146285_a(this.hoveringSlot.func_75211_c(), event.mouseX, event.mouseY);
                this.effectRenderer.renderAspectsInGui((GuiContainer)event.gui, (EntityPlayer)player);
            } else {
                this.renderPlayerAspects(event.gui, event.mouseX, event.mouseY);
            }
        }
    }

    public void renderPlayerAspects(GuiScreen gui, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        int shiftX = Thaumcraft.instance.aspectShift ? -16 : -8;
        int shiftY = Thaumcraft.instance.aspectShift ? -16 : -8;
        int x = mouseX + 17;
        int y = mouseY + 7 - 33;
        EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        AspectList aspectList = ScanManager.generateEntityAspects((Entity)entityPlayer);
        if (aspectList != null) {
            GL11.glDisable((int)2929);
            if (aspectList.size() > 0) {
                Aspect[] sortedAspects;
                for (Aspect aspect : sortedAspects = aspectList.getAspectsSortedAmount()) {
                    if (aspect == null) continue;
                    UtilsFX.bindTexture((String)"textures/aspects/_back.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslatef((float)((x += 18) + shiftX - 2), (float)(y + shiftY - 2), (float)0.0f);
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)0.0f);
                    UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(entityPlayer.func_70005_c_(), aspect)) {
                        UtilsFX.drawTag((int)(x + shiftX), (int)(y + shiftY), (Aspect)aspect, (float)aspectList.getAmount(aspect), (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                        continue;
                    }
                    UtilsFX.bindTexture((String)"textures/aspects/_unknown.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslatef((float)(x + shiftX), (float)(y + shiftY), (float)0.0f);
                    UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
            GL11.glEnable((int)2929);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderScanningProgress(GuiScreen gui, int mouseX, int mouseY, float progress) {
        StringBuilder sb = new StringBuilder("\u00a76");
        sb.append(I18n.func_135052_a((String)"tcinventoryscan:scanning", (Object[])new Object[0]));
        if (progress >= 0.75f) {
            sb.append("...");
        } else if (progress >= 0.5f) {
            sb.append("..");
        } else if (progress >= 0.25f) {
            sb.append(".");
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        float oldZLevel = gui.field_73735_i;
        gui.field_73735_i = 300.0f;
        Minecraft.func_71410_x().field_71466_p.func_78261_a(sb.toString(), mouseX, mouseY - 30, Integer.MAX_VALUE);
        gui.field_73735_i = oldZLevel;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public boolean isHoveringPlayer(GuiContainer gui, int mouseX, int mouseY) {
        return gui instanceof GuiInventory && mouseX >= gui.field_147003_i + 26 && mouseX < gui.field_147003_i + 26 + 52 && mouseY >= gui.field_147009_r + 8 && mouseY < gui.field_147009_r + 8 + 70;
    }
}

