/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.sintinium.oauth.OAuthConfig;
import com.sintinium.oauth.gui.ActionButton;
import com.sintinium.oauth.gui.GuiScreenCustom;
import com.sintinium.oauth.gui.OAuthCheckbox;
import com.sintinium.oauth.gui.PasswordFieldWidget;
import com.sintinium.oauth.gui.ResponsiveButton;
import com.sintinium.oauth.login.LoginUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class LoginScreen
extends GuiScreenCustom {
    private final GuiScreen lastScreen;
    private final GuiMultiplayer multiplayerScreen;
    private ActionButton mojangLoginButton;
    private PasswordFieldWidget passwordWidget;
    private OAuthCheckbox savePasswordWidget;
    private GuiTextField usernameWidget;
    private AtomicReference<String> status = new AtomicReference();
    private String title = I18n.func_135052_a((String)"oauth.screen.title.mojang", (Object[])new Object[0]);
    private List<Runnable> toRun = new CopyOnWriteArrayList<Runnable>();

    public LoginScreen(GuiScreen last, GuiMultiplayer multiplayerScreen) {
        this.lastScreen = last;
        this.multiplayerScreen = multiplayerScreen;
    }

    public void func_146280_a(Minecraft mcIn, int w, int h) {
        String user = "";
        if (this.usernameWidget != null) {
            user = this.usernameWidget.func_146179_b();
        }
        String pass = "";
        if (this.passwordWidget != null) {
            pass = this.passwordWidget.func_146179_b();
        }
        super.func_146280_a(mcIn, w, h);
        this.func_73866_w_();
        this.usernameWidget.func_146180_a(user);
        this.passwordWidget.func_146180_a(pass);
    }

    public void func_73876_c() {
        this.usernameWidget.func_146178_a();
        this.passwordWidget.func_146178_a();
        if (!this.toRun.isEmpty()) {
            for (Runnable r : this.toRun) {
                r.run();
            }
            this.toRun.clear();
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.passwordWidget = new PasswordFieldWidget(this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20, 200, 20);
        this.passwordWidget.func_146203_f(128);
        this.usernameWidget = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 60, 200, 20);
        this.usernameWidget.func_146195_b(true);
        if (LoginUtil.lastMojangUsername != null) {
            this.usernameWidget.func_146180_a(LoginUtil.lastMojangUsername);
        }
        this.savePasswordWidget = this.addButton(new OAuthCheckbox(4, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"oauth.text.savepassword", (Object[])new Object[0])) - 25, this.field_146295_m / 2 + 1 + 2, I18n.func_135052_a((String)"oauth.text.savepassword", (Object[])new Object[0]), false));
        Runnable savePw = () -> {
            if (this.savePasswordWidget.isChecked()) {
                this.saveLoginInfo();
            } else {
                this.removeLoginInfo();
            }
        };
        this.mojangLoginButton = this.addButton(new ResponsiveButton(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 36, 200, 20, I18n.func_135052_a((String)"oauth.btn.login", (Object[])new Object[0]), () -> {
            Thread thread = new Thread(() -> {
                if (this.usernameWidget.func_146179_b().isEmpty()) {
                    this.toRun.add(() -> this.status.set(I18n.func_135052_a((String)"oauth.text.username.missing", (Object[])new Object[0])));
                } else {
                    Optional<Boolean> didSuccessfullyLogIn = LoginUtil.loginMojangOrLegacy(this.usernameWidget.func_146179_b(), this.passwordWidget.func_146179_b());
                    savePw.run();
                    if (!didSuccessfullyLogIn.isPresent()) {
                        this.toRun.add(() -> this.status.set(I18n.func_135052_a((String)"oauth.text.maybe.offline", (Object[])new Object[0])));
                    } else if (!didSuccessfullyLogIn.get().booleanValue()) {
                        this.toRun.add(() -> this.status.set(I18n.func_135052_a((String)"oauth.text.usernameorpassword.wrong", (Object[])new Object[0])));
                    } else {
                        LoginUtil.updateOnlineStatus();
                        this.toRun.add(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)this.multiplayerScreen));
                    }
                }
            });
            thread.start();
        }, this::updateLoginButton, () -> {
            this.mojangLoginButton.field_146126_j = I18n.func_135052_a((String)"oauth.btn.login", (Object[])new Object[0]);
        }));
        this.addButton(new ActionButton(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 60, 200, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), () -> {
            if (!this.savePasswordWidget.isChecked()) {
                this.removeLoginInfo();
            }
            Minecraft.func_71410_x().func_147108_a(this.lastScreen);
        }));
        this.cleanUp();
        if (OAuthConfig.isSavedPassword()) {
            this.usernameWidget.func_146180_a(OAuthConfig.getUsername());
            this.passwordWidget.func_146180_a(OAuthConfig.getPassword());
            this.savePasswordWidget.setIsChecked(true);
        }
    }

    private void saveLoginInfo() {
        OAuthConfig.setUsername(this.usernameWidget.func_146179_b());
        OAuthConfig.setPassword(this.passwordWidget.func_146179_b());
    }

    private void removeLoginInfo() {
        OAuthConfig.removeUsernamePassword();
    }

    private void updateLoginButton() {
        this.mojangLoginButton.field_146126_j = this.passwordWidget.func_146179_b().isEmpty() ? I18n.func_135052_a((String)"btn.login.offline", (Object[])new Object[0]) : I18n.func_135052_a((String)"btn.login", (Object[])new Object[0]);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void cleanUp() {
        this.mojangLoginButton.field_146124_l = !this.usernameWidget.func_146179_b().isEmpty();
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ActionButton) {
            ((ActionButton)button).onClicked();
        } else if (!(button instanceof OAuthCheckbox)) {
            throw new RuntimeException("Missing button action");
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        this.usernameWidget.func_146201_a(typedChar, keyCode);
        this.passwordWidget.func_146201_a(typedChar, keyCode);
        this.cleanUp();
        if (keyCode == 15) {
            this.usernameWidget.func_146195_b(!this.passwordWidget.func_146206_l());
            this.passwordWidget.func_146195_b(!this.usernameWidget.func_146206_l());
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.usernameWidget.func_146192_a(mouseX, mouseY, mouseButton);
        this.passwordWidget.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.func_73732_a(this.field_146297_k.field_71466_p, this.title, this.field_146294_l / 2, 17, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"oauth.text.usernameoremail", (Object[])new Object[0]), this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 60 - 12, 0xA0A0A0);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"oauth.text.password", (Object[])new Object[0]), this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 20 - 12, 0xA0A0A0);
        if (this.status.get() != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, this.status.get(), this.field_146294_l / 2, this.field_146295_m / 2 + 20, 0xFF0000);
        }
        this.usernameWidget.func_146194_f();
        this.passwordWidget.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

