/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import com.gtnewhorizons.navigator.api.model.steps.UniversalRenderStep;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UniversalLayerRenderer
extends LayerRenderer {
    private Function<ILocationProvider, UniversalRenderStep<?>> stepCreator;
    private int renderPriority = 0;

    public UniversalLayerRenderer(@Nonnull LayerManager manager) {
        super(manager, SupportedMods.NONE);
    }

    public UniversalLayerRenderer withRenderStep(@Nonnull Function<ILocationProvider, UniversalRenderStep<?>> supplier) {
        this.stepCreator = supplier;
        return this;
    }

    public UniversalLayerRenderer withRenderPriority(int renderPriority) {
        this.renderPriority = renderPriority;
        return this;
    }

    @Override
    @Nullable
    protected RenderStep generateRenderStep(ILocationProvider location) {
        if (this.stepCreator != null) {
            return this.stepCreator.apply(location);
        }
        return null;
    }

    @Override
    public int getRenderPriority() {
        return this.renderPriority;
    }

    public List<UniversalRenderStep<?>> getRenderSteps() {
        return super.getRenderSteps();
    }
}

