/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.fluid.FluidInteractions;
import com.cleanroommc.modularui.utils.fluid.FluidTanksHandler;
import com.cleanroommc.modularui.utils.fluid.IFluidTankLong;
import com.cleanroommc.modularui.utils.fluid.IFluidTanksHandler;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.google.common.primitives.Ints;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlotLongSyncHandler
extends ValueSyncHandler<IFluidTankLong> {
    @NotNull
    private final IFluidTanksHandler handler;
    private final int index;
    @NotNull
    private IFluidTankLong cache;
    private boolean canFillSlot = true;
    private boolean canDrainSlot = true;
    private boolean controlsAmount = true;
    private boolean phantom = false;
    @Nullable
    private Fluid lastStoredPhantomFluid;

    public FluidSlotLongSyncHandler(IFluidTankLong tank) {
        this(new FluidTanksHandler(tank), 0);
    }

    public FluidSlotLongSyncHandler(IFluidTanksHandler handler, int index) {
        this.handler = handler;
        this.index = index;
        this.cache = handler.getTank(index).copy();
    }

    @Override
    public void setValue(IFluidTankLong value, boolean setSource, boolean sync) {
        this.cache = value.copy();
        if (setSource) {
            this.handler.drain(this.index, Long.MAX_VALUE, true);
            if (value.getFluidAmountLong() == 0L) {
                this.handler.fill(this.index, value.getRealFluid(), value.getFluidAmountLong(), true);
            }
        }
        if (sync) {
            if (NetworkUtils.isClient()) {
                this.syncToServer(0, this::write);
            } else {
                this.syncToClient(0, this::write);
            }
        }
        this.onValueChanged();
    }

    public boolean needsSync() {
        IFluidTankLong current = this.handler.getTank(this.index);
        if (current == this.cache) {
            return false;
        }
        if (current.getRealFluid() == null || this.cache.getRealFluid() == null) {
            return true;
        }
        if (current.getFluidAmountLong() != this.cache.getFluidAmountLong()) {
            return true;
        }
        return current.getRealFluid() != this.cache.getRealFluid();
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (!isFirstSync && !this.needsSync()) {
            return false;
        }
        this.setValue(this.handler.getTank(this.index), false, false);
        return true;
    }

    @Override
    public void write(PacketBuffer buffer) {
        NetworkUtils.writeFluidTank(buffer, this.getValue());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue(NetworkUtils.readFluidTank(buffer), true, false);
    }

    @Override
    public IFluidTankLong getValue() {
        return this.cache;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 0) {
            this.read(buf);
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 0) {
            if (this.phantom) {
                this.read(buf);
            }
        } else if (id == 1) {
            if (this.phantom) {
                this.tryClickPhantom(MouseData.readPacket(buf));
            } else {
                this.tryClickContainer(MouseData.readPacket(buf));
            }
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(MouseData.readPacket(buf));
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        } else if (id == 4) {
            MouseData mouseData = MouseData.readPacket(buf);
            ItemStack draggedStack = NetworkUtils.readItemStack(buf);
            if (this.phantom && draggedStack != null) {
                this.tryClickPhantom(mouseData, draggedStack);
            }
        }
    }

    private void tryClickContainer(MouseData mouseData) {
        boolean processFullStack = mouseData.mouseButton == 0;
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getTank(this.index).getFluid();
        FluidStack heldFluid = FluidInteractions.getFluidForRealItem(heldItemSizedOne);
        if (heldFluid != null && heldFluid.amount <= 0) {
            heldFluid = null;
        }
        if (currentFluid == null) {
            if (!this.canFillSlot) {
                return;
            }
            if (heldFluid == null) {
                return;
            }
            this.fillFluid(heldFluid, processFullStack);
            return;
        }
        if (heldFluid != null && this.handler.getTankAmount(this.index) < this.handler.getTankCapacity(this.index)) {
            if (this.canFillSlot) {
                this.fillFluid(heldFluid, processFullStack);
                return;
            }
            if (!this.canDrainSlot) {
                return;
            }
            this.drainFluid(processFullStack);
            return;
        }
        if (!this.canDrainSlot) {
            return;
        }
        this.drainFluid(processFullStack);
    }

    private void tryClickPhantom(MouseData mouseData) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        this.tryClickPhantom(mouseData, heldItem);
    }

    private void tryClickPhantom(MouseData mouseData, ItemStack heldItem) {
        FluidStack currentFluid = this.handler.getTank(this.index).getFluid();
        if (mouseData.mouseButton == 0) {
            if (heldItem == null) {
                if (this.canDrainSlot) {
                    this.handler.drain(this.index, mouseData.shift ? Long.MAX_VALUE : 1000L, true);
                }
            } else {
                ItemStack heldItemSizedOne = heldItem.func_77946_l();
                heldItemSizedOne.field_77994_a = 1;
                FluidStack heldFluid = FluidInteractions.getFluidForPhantomItem(heldItemSizedOne);
                if ((this.controlsAmount || currentFluid == null) && heldFluid != null) {
                    this.fillPhantom(heldFluid);
                } else if (this.canDrainSlot) {
                    this.handler.drain(this.index, mouseData.shift ? Long.MAX_VALUE : 1000L, true);
                    if (!this.controlsAmount && heldFluid != null && this.handler.getTankAmount(this.index) <= 0L) {
                        this.fillPhantom(heldFluid);
                    }
                }
            }
        } else if (mouseData.mouseButton == 1) {
            if (this.canFillSlot) {
                if (currentFluid != null) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.amount = 1000;
                        this.handler.fill(this.index, toFill.getFluid(), toFill.amount, true);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    this.handler.fill(this.index, this.lastStoredPhantomFluid, this.controlsAmount ? 1000L : 1L, true);
                }
            }
        } else if (mouseData.mouseButton == 2 && currentFluid != null && this.canDrainSlot) {
            this.handler.drain(this.index, mouseData.shift ? Long.MAX_VALUE : 1000L, true);
        }
    }

    private void fillPhantom(FluidStack heldFluid) {
        if (this.canFillSlot) {
            if (!this.controlsAmount) {
                heldFluid.amount = 1;
            }
            if (this.handler.fill(this.index, heldFluid.getFluid(), heldFluid.amount, true) > 0L) {
                this.lastStoredPhantomFluid = heldFluid.getFluid();
            }
        }
    }

    protected void drainFluid(boolean processFullStack) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getTank(this.index).getFluid();
        if (currentFluid == null) {
            return;
        }
        currentFluid = currentFluid.copy();
        long originalFluidAmount = this.handler.getTankAmount(this.index);
        ItemStack filledContainer = FluidInteractions.fillFluidContainer(currentFluid, heldItemSizedOne);
        if (filledContainer != null) {
            long filledAmount = originalFluidAmount - (long)currentFluid.amount;
            if (filledAmount < 1L) {
                return;
            }
            this.handler.drain(this.index, filledAmount, true);
            if (processFullStack) {
                long additionalParallel = Math.min((long)(heldItem.field_77994_a - 1), (long)currentFluid.amount / filledAmount);
                this.handler.drain(this.index, filledAmount * additionalParallel, true);
                filledContainer.field_77994_a = (int)((long)filledContainer.field_77994_a + additionalParallel);
            }
            this.replaceCursorItemStack(filledContainer);
            this.playSound(currentFluid, false);
        }
    }

    protected void fillFluid(@NotNull FluidStack heldFluid, boolean processFullStack) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getTank(this.index).getFluid();
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return;
        }
        long freeSpace = this.handler.getTankCapacity(this.index) - this.handler.getTankAmount(this.index);
        if (freeSpace <= 0L) {
            return;
        }
        ItemStack itemStackEmptied = null;
        long fluidAmountTaken = 0L;
        if (freeSpace >= (long)heldFluid.amount) {
            itemStackEmptied = FluidInteractions.getContainerForFilledItem(heldItemSizedOne);
            fluidAmountTaken = heldFluid.amount;
        }
        if (itemStackEmptied == null) {
            return;
        }
        long parallel = processFullStack ? Math.min(freeSpace / fluidAmountTaken, (long)heldItem.field_77994_a) : 1L;
        FluidStack copiedFluidStack = heldFluid.copy();
        this.handler.fill(this.index, copiedFluidStack.getFluid(), fluidAmountTaken * parallel, true);
        itemStackEmptied.field_77994_a = Ints.saturatedCast((long)parallel);
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
    }

    private void playSound(FluidStack fluid, boolean fill) {
    }

    protected void replaceCursorItemStack(ItemStack resultStack) {
        EntityPlayer player = this.getSyncManager().getPlayer();
        int resultStackMaxStackSize = resultStack.func_77976_d();
        while (resultStack.field_77994_a > resultStackMaxStackSize) {
            player.field_71071_by.func_70445_o().field_77994_a -= resultStackMaxStackSize;
            FluidSlotLongSyncHandler.addItemToPlayerInventory(player, resultStack.func_77979_a(resultStackMaxStackSize));
        }
        if (player.field_71071_by.func_70445_o().field_77994_a == resultStack.field_77994_a) {
            player.field_71071_by.func_70437_b(resultStack);
        } else {
            ItemStack tStackHeld = player.field_71071_by.func_70445_o();
            tStackHeld.field_77994_a -= resultStack.field_77994_a;
            FluidSlotLongSyncHandler.addItemToPlayerInventory(player, resultStack);
        }
    }

    protected static void addItemToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K) {
            EntityItem dropItem = player.func_70099_a(stack, 0.0f);
            dropItem.field_145804_b = 0;
        }
    }

    public void tryScrollPhantom(MouseData mouseData) {
        long amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 10L;
        }
        if (mouseData.ctrl) {
            amount *= 100L;
        }
        if (mouseData.alt) {
            amount *= 1000L;
        }
        if (this.handler.getFluidInTank(this.index) == null) {
            if (amount > 0L && this.lastStoredPhantomFluid != null) {
                this.handler.fill(this.index, this.lastStoredPhantomFluid, amount, true);
            }
            return;
        }
        if (amount > 0L && this.controlsAmount) {
            this.handler.fill(this.index, this.handler.getFluidInTank(this.index), amount, true);
        } else if (amount < 0L) {
            this.handler.drain(this.index, amount, true);
        }
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public boolean controlsAmount() {
        return this.controlsAmount;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public FluidSlotLongSyncHandler phantom(boolean phantom) {
        this.phantom = phantom;
        return this;
    }

    public FluidSlotLongSyncHandler controlsAmount(boolean controlsAmount) {
        this.controlsAmount = controlsAmount;
        if (this.isValid()) {
            this.sync(3, buffer -> buffer.writeBoolean(controlsAmount));
        }
        return this;
    }

    public FluidSlotLongSyncHandler canDrainSlot(boolean canDrainSlot) {
        this.canDrainSlot = canDrainSlot;
        return this;
    }

    public FluidSlotLongSyncHandler canFillSlot(boolean canFillSlot) {
        this.canFillSlot = canFillSlot;
        return this;
    }
}

