/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PosGuiData;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

public class TileEntityGuiFactory
extends AbstractUIFactory<PosGuiData> {
    public static final TileEntityGuiFactory INSTANCE = new TileEntityGuiFactory();

    private TileEntityGuiFactory() {
        super("mui:tile_entity");
    }

    public <T extends TileEntity> void open(EntityPlayer player, T tile) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(tile);
        if (tile.func_145837_r()) {
            throw new IllegalArgumentException("Can't open invalid TileEntity GUI!");
        }
        if (player.field_70170_p != tile.func_145831_w()) {
            throw new IllegalArgumentException("TileEntity must be in same dimension as the player!");
        }
        PosGuiData data = new PosGuiData(player, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    public void open(EntityPlayer player, int x, int y, int z) {
        Objects.requireNonNull(player);
        PosGuiData data = new PosGuiData(player, x, y, z);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    @Override
    @NotNull
    public IGuiHolder<PosGuiData> getGuiHolder(PosGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getTileEntity()), "Found TileEntity is not a gui holder!");
    }

    @Override
    public void writeGuiData(PosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
    }

    @Override
    @NotNull
    public PosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }
}

