/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class SidedTileEntityGuiFactory
extends AbstractUIFactory<SidedPosGuiData> {
    public static final SidedTileEntityGuiFactory INSTANCE = new SidedTileEntityGuiFactory();

    public <T extends TileEntity> void open(EntityPlayer player, T tile, ForgeDirection side) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(tile);
        Objects.requireNonNull(side);
        if (tile.func_145837_r()) {
            throw new IllegalArgumentException("Can't open invalid TileEntity GUI!");
        }
        if (player.field_70170_p != tile.func_145831_w()) {
            throw new IllegalArgumentException("TileEntity must be in same dimension as the player!");
        }
        SidedPosGuiData data = new SidedPosGuiData(player, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, side);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    public void open(EntityPlayer player, int x, int y, int z, ForgeDirection side) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(side);
        SidedPosGuiData data = new SidedPosGuiData(player, x, y, z, side);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    private SidedTileEntityGuiFactory() {
        super("mui:sided_tile");
    }

    @Override
    @NotNull
    public IGuiHolder<SidedPosGuiData> getGuiHolder(SidedPosGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getTileEntity()), "Found TileEntity is not a gui holder!");
    }

    @Override
    public void writeGuiData(SidedPosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
        buffer.writeByte(guiData.getSide().ordinal());
    }

    @Override
    @NotNull
    public SidedPosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new SidedPosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), ForgeDirection.getOrientation((int)buffer.readByte()));
    }
}

