/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.config;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static Configuration config;
    public static int openCloseDurationMs;
    public static boolean openCloseFade;
    public static boolean openCloseScale;
    public static boolean openCloseTranslateFromBottom;
    public static boolean openCloseRotateFast;
    public static boolean smoothProgressbar;
    public static String textCursor;
    public static boolean escRestoreLastText;
    public static boolean closeWindowsAtOnce;
    public static Locale locale;
    public static boolean useJson;
    public static boolean debug;
    public static boolean forceEnableDebugBlock;
    public static final String CATEGORY_ANIMATIONS = "animations";
    public static final String CATEGORY_RENDERING = "rendering";
    public static final String CATEGORY_KEYBOARD = "keyboard";
    public static final String CATEGORY_LOCALIZATION = "localization";
    public static final String CATEGORY_JSON = "json";
    public static final String CATEGORY_DEBUG = "debug";
    private static final String LANG_PREFIX = "modularui.config.";
    public static final String[] CATEGORIES;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        Config.syncConfig();
    }

    public static void syncConfig() {
        config.setCategoryComment(CATEGORY_ANIMATIONS, "Animations");
        config.setCategoryLanguageKey(CATEGORY_ANIMATIONS, "modularui.config.animations");
        config.setCategoryComment(CATEGORY_RENDERING, "Rendering");
        config.setCategoryLanguageKey(CATEGORY_RENDERING, "modularui.config.rendering");
        config.setCategoryComment(CATEGORY_KEYBOARD, "Keyboard");
        config.setCategoryLanguageKey(CATEGORY_KEYBOARD, "modularui.config.keyboard");
        config.setCategoryComment(CATEGORY_LOCALIZATION, "Localization");
        config.setCategoryLanguageKey(CATEGORY_LOCALIZATION, "modularui.config.localization");
        config.setCategoryComment(CATEGORY_JSON, "Json");
        config.setCategoryLanguageKey(CATEGORY_JSON, "modularui.config.json");
        config.setCategoryComment(CATEGORY_DEBUG, "Debug");
        config.setCategoryLanguageKey(CATEGORY_DEBUG, "modularui.config.debug");
        openCloseDurationMs = config.get(CATEGORY_ANIMATIONS, "openCloseDurationMs", 200, "How many milliseconds will it take to draw open/close animation", 0, 3000).setLanguageKey("modularui.config.animations.openCloseDurationMs").getInt();
        openCloseFade = config.get(CATEGORY_ANIMATIONS, "openCloseFade", false, "Whether to draw fade in/out animation on GUI open/close").setLanguageKey("modularui.config.animations.openCloseFade").getBoolean();
        openCloseScale = config.get(CATEGORY_ANIMATIONS, "openCloseScale", false, "Whether to draw scale in/out animation on GUI open/close").setLanguageKey("modularui.config.animations.openCloseScale").getBoolean();
        openCloseTranslateFromBottom = config.get(CATEGORY_ANIMATIONS, "openCloseTranslateFromBottom", false, "Whether to draw GUI coming out of / going out to the bottom of the screen on GUI open/close").setLanguageKey("modularui.config.animations.openCloseTranslateFromBottom").getBoolean();
        openCloseRotateFast = config.get(CATEGORY_ANIMATIONS, "openCloseRotateFast", false, "Whether to draw GUI rotating fast on GUI open/close").setLanguageKey("modularui.config.animations.openCloseRotateFast").getBoolean();
        smoothProgressbar = config.get(CATEGORY_RENDERING, "smoothProgressbar", true, "Draw progress bar smoothly").setLanguageKey("modularui.config.rendering.smoothProgressbar").getBoolean();
        textCursor = config.get(CATEGORY_RENDERING, "textCursor", "underscore", "Select: underscore, vertical", new String[]{"underscore", "vertical"}).setLanguageKey("modularui.config.rendering.textCursor").getString();
        escRestoreLastText = config.get(CATEGORY_KEYBOARD, "escRestoreLastText", false, "Whether to restore last text if esc key is pressed in the text field").setLanguageKey("modularui.config.keyboard.escRestoreLastText").getBoolean();
        closeWindowsAtOnce = config.get(CATEGORY_KEYBOARD, "closeWindowsAtOnce", false, "Whether to close all the opened windows at once").setLanguageKey("modularui.config.keyboard.closeWindowsAtOnce").getBoolean();
        Property property = config.get(CATEGORY_LOCALIZATION, "locale", Locale.getDefault().toLanguageTag(), "Locale to use to display GUI elements. Primarily used to display numbers in your regional format.").setLanguageKey("modularui.config.localization.locale");
        Locale newLocale = Locale.forLanguageTag(property.getString());
        if (NumberFormat.getNumberInstance(newLocale) instanceof DecimalFormat) {
            locale = newLocale;
        } else {
            property.set(locale.toLanguageTag());
        }
        useJson = config.get(CATEGORY_JSON, "useJson", false, "Whether to enable Json. Enabling this will increase loading time.").setLanguageKey("modularui.config.json.useJson").getBoolean();
        debug = config.get(CATEGORY_DEBUG, CATEGORY_DEBUG, false, "Enable Debug information display").setLanguageKey("modularui.config.debug.debug").getBoolean();
        forceEnableDebugBlock = config.get(CATEGORY_DEBUG, "forceEnableDebugBlock", false, "Add debug block even in non-dev env").setLanguageKey("modularui.config.debug.forceEnableDebugBlock").setRequiresMcRestart(true).getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        openCloseDurationMs = 200;
        openCloseFade = false;
        openCloseScale = false;
        openCloseTranslateFromBottom = false;
        openCloseRotateFast = false;
        smoothProgressbar = true;
        textCursor = "underscore";
        escRestoreLastText = false;
        closeWindowsAtOnce = false;
        locale = Locale.getDefault();
        useJson = false;
        debug = false;
        forceEnableDebugBlock = false;
        CATEGORIES = new String[]{CATEGORY_ANIMATIONS, CATEGORY_RENDERING, CATEGORY_KEYBOARD, CATEGORY_LOCALIZATION, CATEGORY_JSON, CATEGORY_DEBUG};
    }
}

