/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget.textfield;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.KeyboardUtil;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.DraggableWindowWrapper;
import com.gtnewhorizons.modularui.api.widget.IDraggable;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.api.widget.scroll.IHorizontalScrollable;
import com.gtnewhorizons.modularui.api.widget.scroll.ScrollType;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.ScrollBar;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldHandler;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldRenderer;
import com.gtnewhorizons.modularui.config.Config;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseTextFieldWidget
extends Widget
implements IWidgetParent,
Interactable,
IHorizontalScrollable {
    @Deprecated
    public static final DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
    public static final Pattern NATURAL_NUMS;
    public static final Pattern WHOLE_NUMS;
    public static final Pattern DECIMALS;
    public static final Pattern MATH_EXPRESSION;
    public static final Pattern LETTERS;
    public static final Pattern ANY;
    public static final Pattern BASE_PATTERN;
    protected TextFieldHandler handler = new TextFieldHandler();
    protected List<String> lastText;
    protected TextFieldRenderer renderer = new TextFieldRenderer(this.handler);
    protected Alignment textAlignment = Alignment.TopLeft;
    protected int scrollOffset = 0;
    protected float scale = 1.0f;
    protected int cursorTimer;
    protected boolean focusOnGuiOpen;
    protected DecimalFormat decimalFormat;
    protected ScrollBar scrollBar;

    public BaseTextFieldWidget() {
        this.handler.setRenderer(this.renderer);
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setGroupingUsed(false);
    }

    @Override
    public List<Widget> getChildren() {
        return this.scrollBar == null ? Collections.emptyList() : Collections.singletonList(this.scrollBar);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        if (this.focusOnGuiOpen) {
            this.forceFocus();
        }
    }

    protected void forceFocus() {
        if (NetworkUtils.isClient()) {
            this.getContext().getCursor().updateFocused(this);
        }
        this.handler.markAll();
    }

    @Override
    public void onScreenUpdate() {
        if (this.isFocused() && ++this.cursorTimer == 10) {
            this.renderer.toggleCursor();
            this.cursorTimer = 0;
        }
    }

    @Override
    public void draw(float partialTicks) {
        Point draggableTranslate = this.getDraggableTranslate();
        GuiHelper.useScissor(this.pos.x + draggableTranslate.x, this.pos.y + draggableTranslate.y, this.size.width, this.size.height, () -> {
            GlStateManager.pushMatrix();
            GlStateManager.translate(1 - this.scrollOffset, 1.0f, 0.0f);
            this.renderer.setSimulate(false);
            this.renderer.setScale(this.scale);
            this.renderer.setAlignment(this.textAlignment, -2.0f, this.size.height);
            this.renderer.draw(this.handler.getText());
            GlStateManager.popMatrix();
        });
    }

    protected Point getDraggableTranslate() {
        Point ret = new Point();
        IDraggable draggable = this.getWindow().getContext().getCursor().getDraggable();
        if (!this.isBeingDragged(draggable)) {
            return ret;
        }
        Rectangle draggableArea = draggable.getArea();
        ret.translate(-this.getWindow().getPos().x, -this.getWindow().getPos().y);
        ret.translate(draggableArea.x, draggableArea.y);
        return ret;
    }

    private boolean isBeingDragged(IDraggable draggable) {
        IWidgetParent parent;
        if (draggable == null) {
            return false;
        }
        AtomicBoolean found = new AtomicBoolean(false);
        if (draggable instanceof IWidgetParent) {
            parent = (IWidgetParent)((Object)draggable);
        } else if (draggable instanceof DraggableWindowWrapper) {
            parent = ((DraggableWindowWrapper)draggable).getWindow();
        } else {
            return false;
        }
        IWidgetParent.forEachByLayer(parent, (Widget widget) -> {
            if (widget == this) {
                found.set(true);
                return true;
            }
            return false;
        });
        return found.get();
    }

    @Override
    public boolean shouldGetFocus() {
        this.cursorTimer = 0;
        this.renderer.setCursor(true);
        this.lastText = new ArrayList<String>(this.handler.getText());
        return true;
    }

    @Override
    public boolean canHover() {
        return true;
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (!this.isRightBelowMouse()) {
            return Interactable.ClickResult.IGNORE;
        }
        if (buttonId == 1) {
            this.handler.getText().clear();
            return Interactable.ClickResult.SUCCESS;
        }
        this.handler.setCursor(this.renderer.getCursorPos(this.handler.getText(), this.getContext().getCursor().getX() - this.pos.x + this.scrollOffset, this.getContext().getCursor().getY() - this.pos.y));
        return Interactable.ClickResult.SUCCESS;
    }

    @Override
    public void onMouseDragged(int buttonId, long deltaTime) {
        this.handler.setMainCursor(this.renderer.getCursorPos(this.handler.getText(), this.getContext().getCursor().getX() - this.pos.x + this.scrollOffset, this.getContext().getCursor().getY() - this.pos.y));
    }

    @Override
    public boolean onMouseScroll(int direction) {
        return this.scrollBar != null && this.scrollBar.onMouseScroll(direction);
    }

    @Override
    public boolean onKeyPressed(char character, int keyCode) {
        if (!this.isFocused()) {
            return false;
        }
        switch (keyCode) {
            case 28: 
            case 156: {
                if (this.getMaxLines() > 1) {
                    this.handler.newLine();
                } else {
                    this.removeFocus();
                }
                return true;
            }
            case 1: {
                if (Config.escRestoreLastText) {
                    this.handler.getText().clear();
                    this.handler.getText().addAll(this.lastText);
                }
                this.removeFocus();
                return true;
            }
            case 203: {
                this.handler.moveCursorLeft(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return true;
            }
            case 205: {
                this.handler.moveCursorRight(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return true;
            }
            case 200: {
                this.handler.moveCursorUp(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return true;
            }
            case 208: {
                this.handler.moveCursorDown(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return true;
            }
            case 211: {
                this.handler.delete(true);
                return true;
            }
            case 14: {
                this.handler.delete();
                return true;
            }
        }
        if (character == '\u0000') {
            return false;
        }
        if (KeyboardUtil.isKeyComboCtrlC(keyCode)) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            return true;
        }
        if (KeyboardUtil.isKeyComboCtrlV(keyCode)) {
            this.handler.insert(GuiScreen.func_146277_j());
            return true;
        }
        if (KeyboardUtil.isKeyComboCtrlX(keyCode) && this.handler.hasTextMarked()) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            this.handler.delete();
            return true;
        }
        if (KeyboardUtil.isKeyComboCtrlA(keyCode)) {
            this.handler.markAll();
            return true;
        }
        if (this.handler.test(String.valueOf(character))) {
            if (this.handler.hasTextMarked()) {
                this.handler.delete();
            }
            this.handler.insert(String.valueOf(character));
            return true;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() == keyCode) {
            this.removeFocus();
            return true;
        }
        return true;
    }

    @Override
    public void onRemoveFocus() {
        super.onRemoveFocus();
        this.renderer.setCursor(false);
        this.cursorTimer = 0;
        this.scrollOffset = 0;
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(maxWidth, (int)((double)(this.renderer.getFontHeight() * (float)this.getMaxLines()) + 0.5));
    }

    @Override
    public void setHorizontalScrollOffset(int offset) {
        this.scrollOffset = this.scrollBar != null && this.scrollBar.isActive() ? offset : 0;
    }

    @Override
    public int getHorizontalScrollOffset() {
        return this.scrollOffset;
    }

    @Override
    public int getVisibleWidth() {
        return this.size.width;
    }

    @Override
    public int getActualWidth() {
        return (int)Math.ceil(this.renderer.getLastWidth());
    }

    public int getMaxLines() {
        return this.handler.getMaxLines();
    }

    public List<String> getLastText() {
        return this.lastText;
    }

    public BaseTextFieldWidget setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    public BaseTextFieldWidget setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public BaseTextFieldWidget setScrollBar() {
        return this.setScrollBar(0);
    }

    public BaseTextFieldWidget setScrollBar(int posOffset) {
        return this.setScrollBar(ScrollBar.defaultTextScrollBar().setPosOffset(posOffset));
    }

    public BaseTextFieldWidget setScrollBar(@Nullable ScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        this.handler.setScrollBar(scrollBar);
        if (this.scrollBar != null) {
            this.scrollBar.setScrollType(ScrollType.HORIZONTAL, this, null);
        }
        return this;
    }

    public BaseTextFieldWidget setTextColor(int color) {
        this.renderer.setColor(color);
        return this;
    }

    public BaseTextFieldWidget setFocusOnGuiOpen(boolean focused) {
        this.focusOnGuiOpen = focused;
        return this;
    }

    public BaseTextFieldWidget setMaximumFractionDigits(int digits) {
        this.decimalFormat.setMaximumFractionDigits(digits);
        return this;
    }

    public BaseTextFieldWidget setDecimalFormatter(@NotNull DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        return this;
    }

    public DecimalFormat getDecimalFormatter() {
        return this.decimalFormat;
    }

    public static char getDecimalSeparator() {
        return format.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static char getGroupSeparator() {
        return format.getDecimalFormatSymbols().getGroupingSeparator();
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(8);
        NATURAL_NUMS = Pattern.compile("[0-9]*([+\\-*/%^][0-9]*)*");
        WHOLE_NUMS = Pattern.compile("-?[0-9]*([+\\-*/%^][0-9]*)*");
        DECIMALS = Pattern.compile("[0-9]*(\\.[0-9]*)?([+\\-*/%^][0-9]*(\\.[0-9]*)?)*");
        MATH_EXPRESSION = Pattern.compile("[0-9.,_ +\\-*/%^eEkKmMgGbBtT]*");
        LETTERS = Pattern.compile("[a-zA-Z]*");
        ANY = Pattern.compile(".*");
        BASE_PATTERN = Pattern.compile("[A-Za-z0-9\\s_+\\-.,!@#$%^&*();\\\\/|<>\"'\\[\\]?=]");
    }
}

