/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class VanillaButtonWidget
extends ButtonWidget {
    private String displayString;
    private Supplier<Boolean> clickableGetter;
    private final TextRenderer textRenderer = new TextRenderer();
    private IDrawable[] normalBackground = new IDrawable[]{ModularUITextures.VANILLA_BUTTON_NORMAL};
    private IDrawable[] hoveredBackground = new IDrawable[]{ModularUITextures.VANILLA_BUTTON_HOVERED};
    private IDrawable[] disabledBackground = new IDrawable[]{ModularUITextures.VANILLA_BUTTON_DISABLED};

    @Override
    @Nullable
    public IDrawable[] getBackground() {
        if (!this.isClickable()) {
            return this.disabledBackground;
        }
        if (this.isHovering()) {
            return this.hoveredBackground;
        }
        return this.normalBackground;
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (!this.isClickable()) {
            return Interactable.ClickResult.REJECT;
        }
        return super.onClick(buttonId, doubleClick);
    }

    @Override
    public void draw(float partialTicks) {
        if (this.displayString != null) {
            this.textRenderer.setPos(0, 0);
            this.textRenderer.setShadow(true);
            this.textRenderer.setAlignment(Alignment.Center, this.size.width, this.size.height);
            this.textRenderer.setColor(!this.isClickable() ? 0xA0A0A0 : (this.isHovering() ? 0xFFFFA0 : 0xFFFFFF));
            this.textRenderer.draw(this.displayString);
        }
    }

    public boolean isClickable() {
        return this.clickableGetter != null ? this.clickableGetter.get() : true;
    }

    public VanillaButtonWidget setDisplayString(String displayString) {
        this.displayString = displayString;
        return this;
    }

    public VanillaButtonWidget setClickableGetter(Supplier<Boolean> clickableGetter) {
        this.clickableGetter = clickableGetter;
        return this;
    }

    public VanillaButtonWidget setBackground(IDrawable[] normalBackground, IDrawable[] hoveredBackground, IDrawable[] disabledBackground) {
        this.normalBackground = normalBackground;
        this.hoveredBackground = hoveredBackground;
        this.disabledBackground = disabledBackground;
        return this;
    }

    public VanillaButtonWidget setOverlay(IDrawable normalOverlay, IDrawable hoveredOverlay, IDrawable disabledOverlay) {
        return this.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BUTTON_NORMAL, normalOverlay}, new IDrawable[]{ModularUITextures.VANILLA_BUTTON_HOVERED, hoveredOverlay}, new IDrawable[]{ModularUITextures.VANILLA_BUTTON_DISABLED, disabledOverlay});
    }

    public VanillaButtonWidget setOverlay(IDrawable overlay) {
        return this.setOverlay(overlay, overlay, overlay);
    }
}

