/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import com.gtnewhorizons.modularui.common.internal.JsonLoader;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public interface IWidgetBuilder<T extends IWidgetBuilder<T>> {
    @ApiStatus.Internal
    public void addWidgetInternal(Widget var1);

    default public T widget(Widget widget) {
        if (widget != null) {
            this.addWidgetInternal(widget);
        }
        return (T)this;
    }

    default public T widgets(Widget ... widgets) {
        for (Widget widget : widgets) {
            if (widget == null) continue;
            this.addWidgetInternal(widget);
        }
        return (T)this;
    }

    default public T widgets(Collection<Widget> widgets) {
        return this.widgets(widgets.toArray(new Widget[0]));
    }

    default public T widgetWhen(boolean doAdd, Widget widget) {
        if (doAdd) {
            this.widget(widget);
        }
        return (T)this;
    }

    default public T drawable(IDrawable drawable) {
        return this.widget(drawable.asWidget());
    }

    default public T slot(BaseSlot slot) {
        return this.widget(new SlotWidget(slot));
    }

    default public T bindPlayerInventory(EntityPlayer player, Pos2d pos, IDrawable background) {
        return this.widget(SlotGroup.playerInventoryGroup(player, background).setPos(pos));
    }

    default public T bindPlayerInventory(EntityPlayer player, int x, int y) {
        return this.widget(SlotGroup.playerInventoryGroup(player).setPos(new Pos2d(x, y)));
    }

    default public T addFromJson(String mod, String location, UIBuildContext buildContext) {
        return this.addFromJson(new ResourceLocation(mod, location), buildContext);
    }

    default public T addFromJson(String location, UIBuildContext buildContext) {
        return this.addFromJson(new ResourceLocation(location), buildContext);
    }

    default public T addFromJson(ResourceLocation location, UIBuildContext buildContext) {
        JsonObject json = JsonLoader.GUIS.get(location);
        if (json == null) {
            ModularUI.logger.error("Couldn't not find json file {}", new Object[]{location});
            return (T)this;
        }
        JsonHelper.parseJson(this, json, buildContext);
        return (T)this;
    }
}

