/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.screen;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.animation.Eases;
import com.gtnewhorizons.modularui.api.animation.Interpolator;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.config.Config;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;

public class ModularWindow
implements IWidgetParent {
    private ModularUIContext context;
    private final List<Widget> children;
    public final ImmutableBiMap<Integer, ISyncedWidget> syncedWidgets;
    private final BiMap<Integer, ISyncedWidget> dynamicSyncedWidgets = HashBiMap.create();
    private final List<Interactable> interactionListeners = new ArrayList<Interactable>();
    protected boolean initialized = false;
    protected boolean clientOnly = true;
    private final boolean fullScreen;
    private Size size;
    private Pos2d pos = Pos2d.ZERO;
    private PosProvider posProvider;
    private final Alignment alignment = Alignment.Center;
    private final IDrawable[] background;
    protected boolean draggable;
    private boolean enabled = true;
    private boolean needsRebuild = false;
    private boolean initSync = true;
    private int alpha = Color.getAlpha(Theme.INSTANCE.getBackground());
    private float scale = 1.0f;
    private float rotation = 0.0f;
    private float translateX = 0.0f;
    private float translateY = 0.0f;
    private Interpolator openAnimation;
    private Interpolator closeAnimation;
    private int guiTint = 0xFFFFFF;

    public static Builder builder(int width, int height) {
        return new Builder(new Size(width, height));
    }

    public static Builder builder(Size size) {
        return new Builder(size);
    }

    public static Builder builderFullScreen() {
        return new Builder(Size.ZERO);
    }

    public ModularWindow(Size size, List<Widget> children, IDrawable ... background) {
        this.fullScreen = size.isZero();
        this.size = size;
        this.children = children;
        this.background = background;
        IWidgetParent.forEachByLayer((IWidgetParent)this, (Widget widget) -> {
            if (widget instanceof IWidgetParent) {
                ((IWidgetParent)((Object)widget)).initChildren();
            }
        });
        ImmutableBiMap.Builder syncedWidgetBuilder = ImmutableBiMap.builder();
        AtomicInteger i = new AtomicInteger();
        IWidgetParent.forEachByLayer((IWidgetParent)this, (Widget widget) -> {
            if (widget instanceof ISyncedWidget) {
                syncedWidgetBuilder.put((Object)i.getAndIncrement(), (Object)((ISyncedWidget)((Object)widget)));
            }
            if (i.get() == 65536) {
                throw new IndexOutOfBoundsException("Too many synced widgets!");
            }
            return false;
        });
        this.syncedWidgets = syncedWidgetBuilder.build();
        this.posProvider = (screenSize, mainWindow) -> Alignment.Center.getAlignedPos(screenSize, this.size);
    }

    protected void initialize(ModularUIContext context) {
        this.context = context;
        for (Widget widget : this.children) {
            widget.initialize(this, this, 0);
        }
    }

    public void onResize(Size screenSize) {
        if (this.fullScreen) {
            this.size = screenSize;
            this.pos = Pos2d.ZERO;
        } else if (!this.context.tryApplyStoredPos(this)) {
            this.setPos(this.posProvider.getPos(screenSize, this.context.getMainWindow()));
        }
        this.markNeedsRebuild();
    }

    public static boolean anyAnimation() {
        return Config.openCloseDurationMs > 0 && (Config.openCloseFade || Config.openCloseTranslateFromBottom || Config.openCloseScale || Config.openCloseRotateFast);
    }

    public void onOpen() {
        if (this.openAnimation == null && ModularWindow.anyAnimation()) {
            int startY = this.context.getScaledScreenSize().height - this.pos.y;
            this.openAnimation = new Interpolator(0.0f, 1.0f, Config.openCloseDurationMs, Eases.EaseQuadOut, value -> {
                float val = ((Float)value).floatValue();
                if (Config.openCloseFade) {
                    this.alpha = (int)(val * (float)Color.getAlpha(Theme.INSTANCE.getBackground()));
                }
                if (Config.openCloseTranslateFromBottom) {
                    this.translateY = (float)startY * (1.0f - val);
                }
                if (Config.openCloseScale) {
                    this.scale = val;
                }
                if (Config.openCloseRotateFast) {
                    this.rotation = val * 360.0f;
                }
            }, val -> {
                this.alpha = Color.getAlpha(Theme.INSTANCE.getBackground());
                this.translateX = 0.0f;
                this.translateY = 0.0f;
                this.scale = 1.0f;
                this.rotation = 360.0f;
            });
            this.closeAnimation = this.openAnimation.getReversed(Config.openCloseDurationMs, Eases.EaseQuadIn);
            this.openAnimation.forward();
            this.closeAnimation.setCallback(val -> {
                this.closeWindow();
                this.openAnimation = null;
                this.closeAnimation = null;
            });
        }
    }

    public boolean tryClose() {
        if (this.closeAnimation == null) {
            this.closeWindow();
        } else if (!this.closeAnimation.isRunning()) {
            this.closeAnimation.forward();
            return true;
        }
        return false;
    }

    public boolean isClosing() {
        return this.closeAnimation != null && this.closeAnimation.isRunning();
    }

    public void update() {
        for (IDrawable drawable : this.background) {
            drawable.tick();
        }
        IWidgetParent.forEachByLayer((IWidgetParent)this, (Widget widget) -> {
            IDrawable[] background;
            widget.onScreenUpdate();
            Consumer<Widget> ticker = widget.getTicker();
            if (ticker != null) {
                ticker.accept((Widget)widget);
            }
            if ((background = widget.getBackground()) != null) {
                for (IDrawable drawable : background) {
                    if (drawable == null) continue;
                    drawable.tick();
                }
            }
        });
        if (this.needsRebuild) {
            this.rebuild();
        }
    }

    public void frameUpdate(float partialTicks) {
        if (this.openAnimation != null) {
            this.openAnimation.update(partialTicks);
        }
        if (this.closeAnimation != null) {
            this.closeAnimation.update(partialTicks);
        }
    }

    public void serverUpdate() {
        boolean needsUpdate = false;
        for (ISyncedWidget syncedWidget : this.syncedWidgets.values()) {
            syncedWidget.detectAndSendChanges(this.initSync);
            if (!syncedWidget.isMarkedForUpdate()) continue;
            needsUpdate = true;
            syncedWidget.unMarkForUpdate();
        }
        if (needsUpdate) {
            this.getContext().onWidgetUpdate();
        }
        this.initSync = false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void rebuild() {
        for (Widget child : this.getChildren()) {
            child.buildTopToBottom(this.size.asDimension());
        }
        for (Widget child : this.getChildren()) {
            child.buildBottomToTop();
        }
        this.needsRebuild = false;
    }

    public void closeWindow() {
        this.context.closeWindow(this);
    }

    protected void destroyWindow() {
        IWidgetParent.forEachByLayer((IWidgetParent)this, (Widget widget) -> {
            if (this.isEnabled()) {
                widget.onPause();
            }
            widget.onDestroy();
        });
    }

    public void drawWidgets(float partialTicks, boolean foreground) {
        if (foreground) {
            IWidgetParent.forEachByLayer((IWidgetParent)this, (Widget widget) -> {
                widget.drawInForeground(partialTicks);
                return false;
            });
        } else {
            GlStateManager.pushMatrix();
            if (Config.openCloseRotateFast) {
                GlStateManager.translate((float)this.pos.x + (float)this.size.width / 2.0f, (float)this.pos.y + (float)this.size.height / 2.0f, 0.0f);
                GlStateManager.rotate(this.rotation, 0.0f, 0.0f, 1.0f);
                GlStateManager.translate(-((float)this.pos.x + (float)this.size.width / 2.0f), -((float)this.pos.y + (float)this.size.height / 2.0f), 0.0f);
            }
            GlStateManager.translate(this.translateX, this.translateY, 0.0f);
            GlStateManager.scale(this.scale, this.scale, 1.0f);
            GlStateManager.pushMatrix();
            float x = ((float)this.pos.x + (float)this.size.width / 2.0f * (1.0f - this.scale)) / this.scale;
            float y = ((float)this.pos.y + (float)this.size.height / 2.0f * (1.0f - this.scale)) / this.scale;
            GlStateManager.translate(x, y, 0.0f);
            int color = Color.withAlpha(Theme.INSTANCE.getBackground(), this.alpha);
            for (IDrawable drawable : this.background) {
                drawable.applyThemeColor(color);
                IDrawable.applyTintColor(this.getGuiTint());
                drawable.draw(Pos2d.ZERO, this.size, partialTicks);
            }
            GlStateManager.popMatrix();
            for (Widget widget2 : this.getChildren()) {
                widget2.drawInternal(partialTicks);
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.popMatrix();
        }
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public Pos2d getAbsolutePos() {
        return this.pos;
    }

    @Override
    public Pos2d getPos() {
        return this.pos;
    }

    @Override
    public List<Widget> getChildren() {
        return this.children;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public int getGuiTint() {
        return this.guiTint;
    }

    public void setGuiTint(int guiTint) {
        this.guiTint = guiTint;
    }

    @Override
    public ModularUIContext getContext() {
        return this.context;
    }

    public void markNeedsRebuild() {
        this.needsRebuild = true;
    }

    public void setPos(Pos2d pos) {
        this.pos = pos;
        this.context.storeWindowPos(this, pos);
    }

    public boolean doesNeedRebuild() {
        return this.needsRebuild;
    }

    public float getScale() {
        return this.scale;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (this.enabled) {
                IWidgetParent.forEachByLayer((IWidgetParent)this, Widget::onResume);
            } else {
                IWidgetParent.forEachByLayer((IWidgetParent)this, Widget::onPause);
            }
        }
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.pos.x, this.pos.y, this.size.width, this.size.height);
    }

    public IDrawable[] getBackground() {
        return this.background;
    }

    public void addInteractionListener(Interactable interactable) {
        this.interactionListeners.add(interactable);
    }

    public List<Interactable> getInteractionListeners() {
        return this.interactionListeners;
    }

    public void addDynamicSyncedWidget(int id, ISyncedWidget syncedWidget, ISyncedWidget parent) {
        int parentId;
        if (id <= 0 || id > 65535) {
            throw new IllegalArgumentException("Dynamic Synced widget id must be greater than 0 and smaller than 65535 (0xFFFF)");
        }
        if (syncedWidget == null || parent == null) {
            throw new NullPointerException("Can't add dynamic null widget or with null parent!");
        }
        if (this.dynamicSyncedWidgets.containsValue((Object)syncedWidget)) {
            this.dynamicSyncedWidgets.inverse().remove((Object)syncedWidget);
        }
        if (((parentId = this.getSyncedWidgetId(parent)) & 0xFFFF0000) != 0) {
            throw new IllegalStateException("Dynamic synced widgets can't have other dynamic widgets as parent! It's possible with some trickery tho.");
        }
        id = id << 16 & 0xFFFF0000 | parentId;
        this.dynamicSyncedWidgets.put((Object)id, (Object)syncedWidget);
    }

    public int getSyncedWidgetId(ISyncedWidget syncedWidget) {
        Integer id = (Integer)this.syncedWidgets.inverse().get((Object)syncedWidget);
        if (id == null && (id = (Integer)this.dynamicSyncedWidgets.inverse().get((Object)syncedWidget)) == null) {
            throw new NoSuchElementException("Can't find id for ISyncedWidget " + syncedWidget);
        }
        return id;
    }

    public ISyncedWidget getSyncedWidget(int id) {
        ISyncedWidget syncedWidget = (ISyncedWidget)this.syncedWidgets.get((Object)id);
        if (syncedWidget == null && (syncedWidget = (ISyncedWidget)this.dynamicSyncedWidgets.get((Object)id)) == null) {
            throw new NoSuchElementException("Can't find ISyncedWidget for id " + id);
        }
        return syncedWidget;
    }

    public static interface PosProvider {
        public Pos2d getPos(Size var1, ModularWindow var2);
    }

    public static class Builder
    implements IWidgetBuilder<Builder> {
        private final List<Widget> widgets = new ArrayList<Widget>();
        private IDrawable[] background = new IDrawable[0];
        private Size size;
        private PosProvider pos = null;
        private boolean draggable = true;
        private Integer guiTint;

        private Builder(Size size) {
            this.size = size;
        }

        public Builder setBackground(IDrawable ... background) {
            this.background = background;
            return this;
        }

        public Builder setSize(Size size) {
            this.size = size;
            return this;
        }

        public Builder setSize(int width, int height) {
            return this.setSize(new Size(width, height));
        }

        public Builder setPos(PosProvider pos) {
            this.pos = pos;
            return this;
        }

        public Builder setDraggable(boolean draggable) {
            this.draggable = draggable;
            return this;
        }

        public Builder bindPlayerInventory(EntityPlayer player, int marginBottom, IDrawable background) {
            return (Builder)this.bindPlayerInventory(player, new Pos2d(this.size.width / 2 - 81, this.size.height - marginBottom - 76), background);
        }

        public Builder bindPlayerInventory(EntityPlayer player) {
            return this.bindPlayerInventory(player, 7, null);
        }

        public Builder addPlayerInventoryLabel(int x, int y) {
            return (Builder)this.widget(new TextWidget(Text.localised("container.inventory", new Object[0])).setPos(x, y));
        }

        @Override
        public void addWidgetInternal(Widget widget) {
            this.widgets.add(widget);
        }

        public Builder setGuiTint(int guiTint) {
            this.guiTint = guiTint;
            return this;
        }

        public ModularWindow build() {
            ModularWindow window = new ModularWindow(this.size, this.widgets, this.background);
            window.draggable = this.draggable;
            if (this.pos != null) {
                window.posProvider = this.pos;
            }
            if (this.guiTint != null) {
                window.guiTint = this.guiTint;
            }
            return window;
        }
    }
}

