/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.AdaptableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.GuiArea;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class UITexture
implements IDrawable {
    public static final Map<ResourceLocation, UITexture> JSON_TEXTURES = new HashMap<ResourceLocation, UITexture>();
    public static final UITexture DEFAULT = UITexture.fullImage("gui/options_background");
    public final ResourceLocation location;
    public final float u0;
    public final float v0;
    public final float u1;
    public final float v1;

    public UITexture(ResourceLocation location, float u0, float v0, float u1, float v1) {
        if (!location.func_110623_a().endsWith(".png")) {
            location = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".png");
        }
        if (!location.func_110623_a().startsWith("textures/")) {
            location = new ResourceLocation(location.func_110624_b(), "textures/" + location.func_110623_a());
        }
        this.location = location;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
    }

    public static UITexture fullImage(ResourceLocation location) {
        return new UITexture(location, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static UITexture fullImage(String location) {
        return UITexture.fullImage(new ResourceLocation(location));
    }

    public static UITexture fullImage(String mod, String location) {
        return UITexture.fullImage(new ResourceLocation(mod, location));
    }

    public static UITexture partly(ResourceLocation location, int imageWidth, int imageHeight, int u0, int v0, int u1, int v1) {
        return new UITexture(location, (float)u0 / (float)imageWidth, (float)v0 / (float)imageHeight, (float)u1 / (float)imageWidth, (float)v1 / (float)imageHeight);
    }

    public static UITexture partly(String location, int imageWidth, int imageHeight, int u0, int v0, int u1, int v1) {
        return UITexture.partly(new ResourceLocation(location), imageWidth, imageHeight, u0, v0, u1, v1);
    }

    public static UITexture partly(String domain, String location, int imageWidth, int imageHeight, int u0, int v0, int u1, int v1) {
        return UITexture.partly(new ResourceLocation(domain, location), imageWidth, imageHeight, u0, v0, u1, v1);
    }

    public UITexture getSubArea(GuiArea bounds) {
        return this.getSubArea(bounds.x0, bounds.y0, bounds.x1, bounds.y1);
    }

    public UITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new UITexture(this.location, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd));
    }

    public UITexture getFlipped(boolean horizontal, boolean vertical) {
        return this.getSubArea(horizontal ? 1.0f : 0.0f, vertical ? 1.0f : 0.0f, horizontal ? 0.0f : 1.0f, vertical ? 0.0f : 1.0f);
    }

    public UITexture exposeToJson() {
        if (JSON_TEXTURES.containsKey(this.location)) {
            UITexture texture = JSON_TEXTURES.get(this.location);
            ModularUI.logger.error("{} '{}' is already exposed to json with uv {}, {}, {}, {}!", new Object[]{texture.getClass().getSimpleName(), this.location, Float.valueOf(texture.u0), Float.valueOf(texture.v0), Float.valueOf(texture.u1), Float.valueOf(texture.v1)});
        } else {
            JSON_TEXTURES.put(this.location, this);
        }
        return this;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    protected final float calcU(float uNew) {
        return (this.u1 - this.u0) * uNew + this.u0;
    }

    protected final float calcV(float vNew) {
        return (this.v1 - this.v0) * vNew + this.v0;
    }

    @Override
    public void draw(float x, float y, float width, float height, float partialTicks) {
        this.draw(x, y, width, height);
    }

    public void draw(float x, float y, float width, float height) {
        UITexture.draw(this.location, x, y, width, height, this.u0, this.v0, this.u1, this.v1);
    }

    public void drawSubArea(float x, float y, float width, float height, float uStart, float vStart, float uEnd, float vEnd) {
        UITexture.draw(this.location, x, y, width, height, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd));
    }

    public static void draw(ResourceLocation location, float x0, float y0, float width, float height, float u0, float v0, float u1, float v1) {
        float x1 = x0 + width;
        float y1 = y0 + height;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        tessellator.func_78385_a((double)u0, (double)v1);
        tessellator.func_78377_a((double)x0, (double)y1, 0.0);
        tessellator.func_78385_a((double)u1, (double)v1);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78385_a((double)u1, (double)v0);
        tessellator.func_78377_a((double)x1, (double)y0, 0.0);
        tessellator.func_78385_a((double)u0, (double)v0);
        tessellator.func_78377_a((double)x0, (double)y0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public static UITexture ofJson(JsonObject json) {
        if (!json.has("src")) {
            return DEFAULT;
        }
        ResourceLocation rl = new ResourceLocation(json.get("src").getAsString());
        if (JSON_TEXTURES.containsKey(rl)) {
            return JSON_TEXTURES.get(rl);
        }
        float u0 = JsonHelper.getFloat(json, 0.0f, "u", "u0");
        float v0 = JsonHelper.getFloat(json, 0.0f, "v", "v0");
        float u1 = JsonHelper.getFloat(json, 1.0f, "u1");
        float v1 = JsonHelper.getFloat(json, 1.0f, "v1");
        Size imageSize = JsonHelper.getElement(json, Size.ZERO, Size::ofJson, "imageSize");
        int borderWidth = JsonHelper.getInt(json, -1, "borderWidth");
        if (imageSize.width > 0 && imageSize.height > 0 && borderWidth >= 0) {
            return AdaptableUITexture.of(rl, imageSize.width, imageSize.height, borderWidth).getSubArea(u0, v0, u1, v1);
        }
        return new UITexture(rl, u0, v0, u1, v1);
    }
}

