/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.doors.gui.BlockMixerGui;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMixerTileEntity
extends TileEntity
implements IInventoryProvider {
    private MalisisInventory inventory;
    private int mixTimer = 0;
    private int mixTotalTime = 100;
    public MixerSlot firstInput = new MixerSlot(0);
    public MixerSlot secondInput = new MixerSlot(1);
    public MalisisSlot output = new MalisisSlot(2);

    public BlockMixerTileEntity() {
        this.output.setOutputSlot();
        this.inventory = new MalisisInventory((IInventoryProvider)this, new MalisisSlot[]{this.firstInput, this.secondInput, this.output});
    }

    public void func_145845_h() {
        ItemStack firstItemStack = this.firstInput.getItemStack();
        ItemStack secondItemStack = this.secondInput.getItemStack();
        ItemStack outputItemStack = this.output.getItemStack();
        if (firstItemStack == null || secondItemStack == null) {
            this.mixTimer = 0;
            return;
        }
        ItemStack expected = MixedBlockBlockItem.fromItemStacks(firstItemStack, secondItemStack);
        if (expected == null) {
            this.mixTimer = 0;
            return;
        }
        if (!(outputItemStack == null || ItemStack.func_77970_a((ItemStack)outputItemStack, (ItemStack)expected) && outputItemStack.field_77994_a < outputItemStack.func_77976_d())) {
            this.mixTimer = 0;
            return;
        }
        ++this.mixTimer;
        if (this.mixTimer > this.mixTotalTime) {
            this.mixTimer = 0;
            this.firstInput.extract(1);
            this.secondInput.extract(1);
            this.output.insert(expected);
        }
    }

    public float getMixTimer() {
        return (float)this.mixTimer / (float)this.mixTotalTime;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("mixTimer", this.mixTimer);
        this.inventory.writeToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mixTimer = tagCompound.func_74762_e("mixTimer");
        this.inventory.readFromNBT(tagCompound);
    }

    @Override
    public MalisisInventory[] getInventories(Object ... data) {
        return new MalisisInventory[]{this.inventory};
    }

    @Override
    public MalisisInventory[] getInventories(ForgeDirection side, Object ... data) {
        return this.getInventories(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new BlockMixerGui(this, container);
    }

    public class MixerSlot
    extends MalisisSlot {
        public MixerSlot(int index) {
            super(index);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return MixedBlockBlockItem.canBeMixed(itemStack);
        }
    }
}

