/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.ComplexAxisAlignedBoundingBox;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.BigDoorTileEntity;
import net.malisis.doors.door.tileentity.IMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class BigDoor
extends MalisisBlock
implements ITileEntityProvider {
    private final Vec3[][] selectionOpenHoriztonalFaces = new Vec3[][]{{Vec3.func_72443_a((double)0.0, (double)5.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)5.0, (double)0.8125), Vec3.func_72443_a((double)4.0, (double)5.0, (double)0.8125), Vec3.func_72443_a((double)4.0, (double)5.0, (double)1.0)}, {Vec3.func_72443_a((double)0.5, (double)4.0, (double)1.0), Vec3.func_72443_a((double)0.5, (double)4.0, (double)0.8125), Vec3.func_72443_a((double)3.5, (double)4.0, (double)0.8125), Vec3.func_72443_a((double)3.5, (double)4.0, (double)1.0)}, {Vec3.func_72443_a((double)0.0, (double)4.0, (double)0.8125), Vec3.func_72443_a((double)0.0, (double)4.0, (double)-0.5), Vec3.func_72443_a((double)0.5, (double)4.0, (double)-0.5), Vec3.func_72443_a((double)0.5, (double)4.0, (double)0.8125)}, {Vec3.func_72443_a((double)3.5, (double)4.0, (double)0.8125), Vec3.func_72443_a((double)4.0, (double)4.0, (double)0.8125), Vec3.func_72443_a((double)4.0, (double)4.0, (double)-0.5), Vec3.func_72443_a((double)3.5, (double)4.0, (double)-0.5)}, {Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)-0.5), Vec3.func_72443_a((double)0.5, (double)0.0, (double)-0.5), Vec3.func_72443_a((double)0.5, (double)0.0, (double)1.0)}, {Vec3.func_72443_a((double)3.5, (double)0.0, (double)1.0), Vec3.func_72443_a((double)4.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)4.0, (double)0.0, (double)-0.5), Vec3.func_72443_a((double)3.5, (double)0.0, (double)-0.5)}};
    private final Pair<Vec3, Vec3>[] selectionOpenVerticals = new Pair[]{Pair.of((Object)Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)0.0, (double)5.0, (double)1.0)), Pair.of((Object)Vec3.func_72443_a((double)4.0, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)4.0, (double)5.0, (double)1.0)), Pair.of((Object)Vec3.func_72443_a((double)0.5, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)0.5, (double)4.0, (double)1.0)), Pair.of((Object)Vec3.func_72443_a((double)3.5, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)3.5, (double)4.0, (double)1.0)), Pair.of((Object)Vec3.func_72443_a((double)0.0, (double)0.0, (double)-0.5), (Object)Vec3.func_72443_a((double)0.0, (double)4.0, (double)-0.5)), Pair.of((Object)Vec3.func_72443_a((double)0.5, (double)0.0, (double)-0.5), (Object)Vec3.func_72443_a((double)0.5, (double)4.0, (double)-0.5)), Pair.of((Object)Vec3.func_72443_a((double)3.5, (double)0.0, (double)-0.5), (Object)Vec3.func_72443_a((double)3.5, (double)4.0, (double)-0.5)), Pair.of((Object)Vec3.func_72443_a((double)4.0, (double)0.0, (double)-0.5), (Object)Vec3.func_72443_a((double)4.0, (double)4.0, (double)-0.5)), Pair.of((Object)Vec3.func_72443_a((double)0.0, (double)4.0, (double)0.8125), (Object)Vec3.func_72443_a((double)0.0, (double)5.0, (double)0.8125)), Pair.of((Object)Vec3.func_72443_a((double)4.0, (double)4.0, (double)0.8125), (Object)Vec3.func_72443_a((double)4.0, (double)5.0, (double)0.8125))};
    public static int renderId;
    public static int renderPass;
    private AxisAlignedBB defaultBoundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0);
    private Type type;

    public BigDoor(Type type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c(type.name);
        this.func_149647_a(MalisisDoors.tab);
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("malisisdoors:" + this.type.name);
    }

    public String func_149702_O() {
        return "malisisdoors:" + this.type.name + "_item";
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase livingEntity, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)livingEntity);
        int metadata = Door.dirToInt(dir);
        world.func_72921_c(x, y, z, metadata, 2);
        BigDoorTileEntity te = TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te != null) {
            te.setFrameState(BlockState.fromNBT(itemStack.func_77978_p()));
            if (this.checkAreaClearForDoor(world, x, y, z, metadata)) {
                te.onCreate(x, y, z, metadata);
            } else {
                world.func_147468_f(x, y, z);
                if (!world.field_72995_K && livingEntity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)livingEntity;
                    player.func_145747_a((IChatComponent)new ChatComponentText("There's no room for the door!"));
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack doorBlock = new ItemStack((Block)this, 1, 0);
                        EntityItem entityitem = player.func_71019_a(doorBlock, false);
                        entityitem.field_145804_b = 0;
                        entityitem.func_145797_a(player.func_70005_c_());
                    }
                }
            }
        }
    }

    private boolean checkAreaClearForDoor(World world, int x, int y, int z, int meta) {
        boolean validSpot = true;
        boolean widthDirectionFlag = meta % 2 == 0;
        int xStep = meta == 3 ? -1 : 1;
        int zStep = meta == 0 ? -1 : 1;
        int xMax = widthDirectionFlag ? 1 : 4;
        int zMax = widthDirectionFlag ? 4 : 1;
        for (int yLoc = 0; yLoc < 5; ++yLoc) {
            int xLoc = 0;
            while (MathHelper.func_76135_e((float)xLoc) < (float)xMax) {
                int zLoc = 0;
                while (MathHelper.func_76135_e((float)zLoc) < (float)zMax) {
                    Block potentialSpot;
                    if (!(yLoc == 0 && zLoc == 0 && xLoc == 0 || (potentialSpot = world.func_147439_a(x + xLoc, y + yLoc, z + zLoc)).func_149688_o().func_76222_j())) {
                        validSpot = false;
                    }
                    zLoc += zStep;
                }
                xLoc += xStep;
            }
        }
        return validSpot;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int buildHeight = world.func_72800_K() - 6;
        if (y > buildHeight) {
            return;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiBlock) {
            ((IMultiBlock)tileEntity).onDestroy(tileEntity, meta);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        BigDoorTileEntity te = TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        te.onBlockActivated(world, x, y, z, player);
        return true;
    }

    @Override
    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        BigDoorTileEntity te = TileEntityUtils.getTileEntity(BigDoorTileEntity.class, world, x, y, z);
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()};
        if (type == BoundingBoxType.RENDER) {
            aabbs[0].field_72339_c = -0.5;
        } else if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.CHUNKCOLLISION || type == BoundingBoxType.RAYTRACE || type == BoundingBoxType.SELECTION) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)-0.5, (double)0.5, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)3.5, (double)0.0, (double)-0.5, (double)4.0, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)4.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0)};
        }
        return AABBUtils.rotate(aabbs, Door.intToDir(te.getDirection()));
    }

    public ComplexAxisAlignedBoundingBox getComplexBoundingBoxWithOffset(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        BigDoorTileEntity te = TileEntityUtils.getTileEntity(BigDoorTileEntity.class, world, x, y, z);
        if (te == null) {
            return ComplexAxisAlignedBoundingBox.defaultComplexBoundingBox;
        }
        if (type == BoundingBoxType.SELECTION && (te.isOpened() || te.isMoving())) {
            Vec3[][] clonedFlatSurfaces = new Vec3[this.selectionOpenHoriztonalFaces.length][];
            for (int i = 0; i < this.selectionOpenHoriztonalFaces.length; ++i) {
                clonedFlatSurfaces[i] = new Vec3[this.selectionOpenHoriztonalFaces[i].length];
                for (int j = 0; j < this.selectionOpenHoriztonalFaces[i].length; ++j) {
                    Vec3 vec = this.selectionOpenHoriztonalFaces[i][j];
                    clonedFlatSurfaces[i][j] = Vec3.func_72443_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
                }
            }
            Pair[] clonedVerticals = new Pair[this.selectionOpenVerticals.length];
            for (int i = 0; i < this.selectionOpenVerticals.length; ++i) {
                Vec3 left = (Vec3)this.selectionOpenVerticals[i].getLeft();
                Vec3 right = (Vec3)this.selectionOpenVerticals[i].getRight();
                clonedVerticals[i] = Pair.of((Object)Vec3.func_72443_a((double)left.field_72450_a, (double)left.field_72448_b, (double)left.field_72449_c), (Object)Vec3.func_72443_a((double)right.field_72450_a, (double)right.field_72448_b, (double)right.field_72449_c));
            }
            ComplexAxisAlignedBoundingBox CAABB = new ComplexAxisAlignedBoundingBox(clonedFlatSurfaces, clonedVerticals);
            CAABB.rotate(Door.intToDir(te.getDirection()), ComplexAxisAlignedBoundingBox.Axis.Y);
            switch (Door.intToDir(te.getDirection())) {
                case EAST: {
                    CAABB.addOffset(x + 1, y, z);
                    break;
                }
                case NORTH: {
                    CAABB.addOffset(x, y, z);
                    break;
                }
                case SOUTH: {
                    CAABB.addOffset(x + 1, y, z + 1);
                    break;
                }
                case WEST: {
                    CAABB.addOffset(x, y, z + 1);
                }
            }
            return CAABB;
        }
        return ComplexAxisAlignedBoundingBox.defaultComplexBoundingBox;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new BigDoorTileEntity(this.type);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public Type getType() {
        return this.type;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a((float)this.defaultBoundingBox.field_72340_a, (float)this.defaultBoundingBox.field_72338_b, (float)this.defaultBoundingBox.field_72339_c, (float)this.defaultBoundingBox.field_72336_d, (float)this.defaultBoundingBox.field_72337_e, (float)this.defaultBoundingBox.field_72334_f);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return true;
    }

    static {
        renderPass = -1;
    }

    public static enum Type {
        DEFAULT("carriage_door", Items.field_151135_aq),
        CARRIAGE("carriage_door", Items.field_151135_aq),
        MEDIEVAL("medieval_door", MalisisDoors.Items.doorSpruceItem);

        public String name;
        public Item door;

        private Type(String name, Item door) {
            this.name = name;
            this.door = door;
        }
    }
}

