/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.MalisisCore;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlock {
    protected World world;
    protected Block block;
    protected AxisAlignedBB aabb;
    protected ForgeDirection direction;
    protected int x;
    protected int y;
    protected int z;

    public MultiBlock(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MultiBlock(World world, int x, int y, int z) {
        this(x, y, z);
        this.setWorld(world);
    }

    public MultiBlock(World world, int x, int y, int z, AxisAlignedBB aabb) {
        this(x, y, z);
        this.setWorld(world);
        this.setBounds(aabb);
    }

    public MultiBlock(World world, int x, int y, int z, int width, int height, int depth) {
        this(x, y, z);
        this.setWorld(world);
        this.setSize(width, height, depth);
    }

    public MultiBlock(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    private Block getBlock() {
        if (this.block == null && this.world != null) {
            this.block = this.world.func_147439_a(this.x, this.y, this.z);
        }
        return this.block;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setDirection(ForgeDirection direction) {
        this.direction = direction;
    }

    public ForgeDirection getDirection() {
        return this.direction != null ? this.direction : ForgeDirection.UNKNOWN;
    }

    public boolean isOrigin(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public void setSize(int width, int height, int depth) {
        int minX = width > 0 ? 0 : width + 1;
        int maxX = width > 0 ? width : 1;
        int minY = height > 0 ? 0 : height + 1;
        int maxY = height > 0 ? height : 1;
        int minZ = depth > 0 ? 0 : depth + 1;
        int maxZ = depth > 0 ? depth : 1;
        this.setBounds(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
    }

    public void setBounds(AxisAlignedBB aabb) {
        if (aabb.field_72340_a > 0.0 || aabb.field_72336_d < 0.0) {
            throw new IllegalArgumentException("Bounds need to contain X origin point");
        }
        if (aabb.field_72336_d - aabb.field_72340_a < 1.0) {
            throw new IllegalArgumentException("Width needs to be greater or equal to 1");
        }
        if (aabb.field_72338_b > 0.0 || aabb.field_72337_e < 0.0) {
            throw new IllegalArgumentException("Bounds need to contain Y origin point");
        }
        if (aabb.field_72337_e - aabb.field_72338_b < 1.0) {
            throw new IllegalArgumentException("Height needs to be greater or equal to 1");
        }
        if (aabb.field_72339_c > 0.0 || aabb.field_72334_f < 0.0) {
            throw new IllegalArgumentException("Bounds needs to contain X origin point");
        }
        if (aabb.field_72334_f - aabb.field_72339_c < 1.0) {
            throw new IllegalArgumentException("Width need to be greater or equal to 1");
        }
        this.aabb = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
    }

    public AxisAlignedBB getBounds() {
        if (this.aabb == null) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.aabb.field_72340_a, (double)this.aabb.field_72338_b, (double)this.aabb.field_72339_c, (double)this.aabb.field_72336_d, (double)this.aabb.field_72337_e, (double)this.aabb.field_72334_f);
        if (this.direction != null) {
            if (this.direction == ForgeDirection.EAST || this.direction == ForgeDirection.WEST) {
                aabb.func_72324_b(aabb.field_72339_c, aabb.field_72338_b, aabb.field_72340_a, aabb.field_72334_f, aabb.field_72337_e, aabb.field_72336_d);
            }
            double shiftX = 1.0 - aabb.field_72336_d - aabb.field_72340_a;
            double shiftZ = 1.0 - aabb.field_72334_f - aabb.field_72339_c;
            if (this.direction == ForgeDirection.NORTH) {
                aabb.func_72317_d(0.0, 0.0, shiftZ);
            } else if (this.direction == ForgeDirection.SOUTH) {
                aabb.func_72317_d(shiftX, 0.0, 0.0);
            } else if (this.direction == ForgeDirection.WEST) {
                aabb.func_72317_d(shiftX, 0.0, shiftZ);
            }
        }
        return aabb;
    }

    public AxisAlignedBB getWorldBounds() {
        return this.getBounds().func_72317_d((double)this.x, (double)this.y, (double)this.z);
    }

    protected ChunkPosition[] getListPositions() {
        AxisAlignedBB aabb = this.getBounds();
        if (aabb == null) {
            return new ChunkPosition[0];
        }
        int eX = this.x + (int)aabb.field_72336_d;
        int sX = this.x + (int)aabb.field_72340_a;
        int eY = this.y + (int)aabb.field_72337_e;
        int sY = this.y + (int)aabb.field_72338_b;
        int eZ = this.z + (int)aabb.field_72334_f;
        int sZ = this.z + (int)aabb.field_72339_c;
        int size = (eX - sX) * (eY - sY) * (eZ - sZ) - 1;
        ChunkPosition[] pos = new ChunkPosition[size >= 0 ? size : 0];
        int n = 0;
        for (int i = sX; i < eX; ++i) {
            for (int j = sY; j < eY; ++j) {
                for (int k = sZ; k < eZ; ++k) {
                    if (i == this.x && j == this.y && k == this.z) continue;
                    pos[n++] = new ChunkPosition(i, j, k);
                }
            }
        }
        return pos;
    }

    public boolean placeBlocks() {
        return this.placeBlocks(false);
    }

    public boolean placeBlocks(boolean placeOrigin) {
        ChunkPosition[] listPos;
        if (placeOrigin) {
            if (this.getBlock() == null) {
                MalisisCore.log.error("[MultiBlock] Tried to set multiblock origin at {}, {}, {}, but no block is set.", new Object[]{this.x, this.y, this.z});
                return false;
            }
            if (this.getBlock().func_149742_c(this.world, this.x, this.y, this.z)) {
                this.world.func_147465_d(this.x, this.y, this.z, this.getBlock(), 0, 3);
            } else {
                return false;
            }
        }
        for (ChunkPosition pos : listPos = this.getListPositions()) {
            if (pos == null) {
                return false;
            }
            if (this.getBlock().func_149742_c(this.world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) continue;
            this.world.func_147468_f(this.x, this.y, this.z);
            return false;
        }
        IProvider te = TileEntityUtils.getTileEntity(IProvider.class, (IBlockAccess)this.world, this.x, this.y, this.z);
        if (te == null) {
            MalisisCore.log.error("[MultiBlock] Tried to set multiblock in provider, but no IProvider found at {}, {}, {}", new Object[]{this.x, this.y, this.z});
            return false;
        }
        te.setMultiBlock(this);
        for (ChunkPosition pos : listPos) {
            this.world.func_147465_d(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, this.getBlock(), 0, 1);
            te = TileEntityUtils.getTileEntity(IProvider.class, (IBlockAccess)this.world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            te.setMultiBlock(this);
        }
        return true;
    }

    public boolean removeBlocks() {
        ChunkPosition[] listPos;
        if (this.world == null) {
            return false;
        }
        for (ChunkPosition pos : listPos = this.getListPositions()) {
            this.world.func_147465_d(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, Blocks.field_150350_a, 0, 2);
        }
        this.world.func_147468_f(this.x, this.y, this.z);
        return true;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound mbTag = new NBTTagCompound();
        mbTag.func_74768_a("x", this.x);
        mbTag.func_74768_a("y", this.y);
        mbTag.func_74768_a("z", this.z);
        if (this.direction != null) {
            mbTag.func_74768_a("direction", this.direction.ordinal());
        }
        if (this.aabb != null) {
            AABBUtils.writeToNBT(mbTag, this.aabb);
        }
        tag.func_74782_a("multiBlock", (NBTBase)mbTag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("multiBlock")) {
            MalisisCore.log.error("[MultiBlock] Couldn't read MultiBlock informations from tag {}", new Object[]{tag});
            return;
        }
        tag = tag.func_74775_l("multiBlock");
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        this.aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        this.aabb = AABBUtils.readFromNBT(tag, this.aabb);
        if (tag.func_74764_b("direction")) {
            this.direction = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
        }
    }

    public static boolean destroy(World world, int x, int y, int z) {
        IProvider te = TileEntityUtils.getTileEntity(IProvider.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            MalisisCore.log.error("[MultiBlock] Couldn't find IProvider at {}, {}, {}", new Object[]{x, y, z});
            return false;
        }
        MultiBlock mb = te.getMultiBlock();
        if (mb == null) {
            MalisisCore.log.error("[MultiBlock] No MultiBlock for IProvider at {}, {}, {}", new Object[]{x, y, z});
            return false;
        }
        return mb.removeBlocks();
    }

    public static MultiBlock getMultiBlock(IBlockAccess world, int x, int y, int z) {
        IProvider provider = TileEntityUtils.getTileEntity(IProvider.class, world, x, y, z);
        if (provider == null) {
            return null;
        }
        return provider.getMultiBlock();
    }

    public static boolean isOrigin(IBlockAccess world, int x, int y, int z) {
        MultiBlock mb = MultiBlock.getMultiBlock(world, x, y, z);
        if (mb == null) {
            return false;
        }
        return mb.isOrigin(x, y, z);
    }

    public static <T extends TileEntity> T getOriginProvider(Class<T> providerClass, IBlockAccess world, int x, int y, int z) {
        return (T)MultiBlock.getOriginProvider((TileEntity)TileEntityUtils.getTileEntity(providerClass, world, x, y, z));
    }

    public static <T extends TileEntity> T getOriginProvider(T provider) {
        if (provider == null) {
            return null;
        }
        MultiBlock mb = ((IProvider)provider).getMultiBlock();
        if (mb == null) {
            return null;
        }
        if (provider.field_145851_c == mb.x && provider.field_145848_d == mb.y && provider.field_145849_e == mb.z) {
            return provider;
        }
        TileEntity te = provider.func_145831_w().func_147438_o(mb.x, mb.y, mb.z);
        if (te == null || !(te instanceof IProvider)) {
            return null;
        }
        if (provider.getClass().isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    public static interface IProvider {
        public void setMultiBlock(MultiBlock var1);

        public MultiBlock getMultiBlock();
    }
}

