/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import java.util.HashMap;
import java.util.Map;
import magicbees.api.bees.AuraChargeType;
import magicbees.api.bees.IMagicApiaryAuraProvider;
import magicbees.bees.AuraCharge;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;

public class TileEntityVisAuraProvider
extends TileEntity
implements IMagicApiaryAuraProvider {
    public static final String tileEntityName = "magicbees.visAuraProvider";
    private static final int MAX_CHARGES = 10;
    private static final int VIS_PER_CHARGE = 8;
    private static Map<AuraChargeType, Aspect> aspectMap = new HashMap<AuraChargeType, Aspect>(AuraChargeType.values().length);
    private final Map<AuraCharge, VisAuraCharge> currentCharges;

    public TileEntityVisAuraProvider() {
        AuraCharge[] auraChargeTypes = AuraCharge.values();
        this.currentCharges = new HashMap<AuraCharge, VisAuraCharge>(auraChargeTypes.length);
        for (AuraCharge auraChargeType : auraChargeTypes) {
            this.currentCharges.put(auraChargeType, new VisAuraCharge());
        }
    }

    public void func_145845_h() {
        long tick = this.field_145850_b.func_82737_E();
        for (Map.Entry<AuraCharge, VisAuraCharge> currentCharge : this.currentCharges.entrySet()) {
            AuraCharge type = currentCharge.getKey();
            VisAuraCharge auraCharge = currentCharge.getValue();
            if (auraCharge.charges >= 10 || tick % (long)type.tickRate != 0L) continue;
            auraCharge.vis += this.getVisFromNet(aspectMap.get((Object)type.type));
            if (auraCharge.vis < 8) continue;
            auraCharge.vis -= 8;
            ++auraCharge.charges;
        }
    }

    private int getVisFromNet(Aspect aspect) {
        return VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Aspect)aspect, (int)1);
    }

    @Override
    public boolean getMutationCharge() {
        return this.getCharge(AuraChargeType.MUTATION);
    }

    @Override
    public boolean getDeathRateCharge() {
        return this.getCharge(AuraChargeType.DEATH);
    }

    @Override
    public boolean getProductionCharge() {
        return this.getCharge(AuraChargeType.PRODUCTION);
    }

    @Override
    public boolean getCharge(AuraChargeType auraChargeType) {
        VisAuraCharge auraCharge = this.currentCharges.get((Object)AuraCharge.fromChargeType(auraChargeType));
        if (auraCharge == null) {
            return false;
        }
        if (auraCharge.charges > 0) {
            --auraCharge.charges;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (Map.Entry<AuraCharge, VisAuraCharge> charge : this.currentCharges.entrySet()) {
            String auraName = charge.getKey().toString();
            int[] array = tag.func_74759_k(auraName);
            VisAuraCharge auraCharge = charge.getValue();
            auraCharge.fromArray(array);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (Map.Entry<AuraCharge, VisAuraCharge> charge : this.currentCharges.entrySet()) {
            String auraName = charge.getKey().toString();
            VisAuraCharge auraCharge = charge.getValue();
            int[] array = auraCharge.toArray();
            tag.func_74783_a(auraName, array);
        }
    }

    static {
        aspectMap.put(AuraChargeType.MUTATION, Aspect.WATER);
        aspectMap.put(AuraChargeType.DEATH, Aspect.ENTROPY);
        aspectMap.put(AuraChargeType.PRODUCTION, Aspect.AIR);
    }

    private static class VisAuraCharge {
        int charges;
        int vis;

        private VisAuraCharge() {
        }

        public int[] toArray() {
            return new int[]{this.charges, this.vis};
        }

        public void fromArray(int[] array) {
            if (array.length == 2) {
                this.charges = array[0];
                this.vis = array[1];
            }
        }
    }
}

