/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import java.util.HashMap;
import java.util.Map;
import magicbees.bees.AuraCharge;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AuraCharges {
    private static final String auraChargesTagName = "AuraCharges";
    private final Map<AuraCharge, Long> charges = new HashMap<AuraCharge, Long>(AuraCharge.values().length);

    public void start(AuraCharge auraChargeType, World worldObj) {
        this.charges.put(auraChargeType, worldObj.func_82737_E());
    }

    public boolean isActive(AuraCharge auraChargeType) {
        return this.charges.keySet().contains((Object)auraChargeType);
    }

    public boolean isExpired(AuraCharge auraChargeType, World worldObj) {
        Long chargeStart = this.charges.get((Object)auraChargeType);
        return chargeStart == null || chargeStart + (long)auraChargeType.duration <= worldObj.func_82737_E();
    }

    public void stop(AuraCharge AuraChargeType2) {
        this.charges.remove((Object)AuraChargeType2);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound auraChargeTags = new NBTTagCompound();
        for (Map.Entry<AuraCharge, Long> chargeEntry : this.charges.entrySet()) {
            String chargeName = chargeEntry.getKey().toString();
            Long chargeStart = chargeEntry.getValue();
            auraChargeTags.func_74772_a(chargeName, chargeStart.longValue());
        }
        nbtTagCompound.func_74782_a(auraChargesTagName, (NBTBase)auraChargeTags);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound auraChargeTags = nbtTagCompound.func_74775_l(auraChargesTagName);
        for (AuraCharge auraCharge : AuraCharge.values()) {
            String chargeName = auraCharge.toString();
            Long chargeStart = auraChargeTags.func_74763_f(chargeName);
            if (chargeStart <= 0L) continue;
            this.charges.put(auraCharge, chargeStart);
        }
    }

    public int writeToFlags() {
        int flags = 0;
        for (AuraCharge auraChargeType : this.charges.keySet()) {
            flags |= auraChargeType.flag;
        }
        return flags;
    }

    public void readFromFlags(int flags) {
        this.charges.clear();
        for (AuraCharge auraCharge : AuraCharge.values()) {
            if ((flags & auraCharge.flag) <= 0) continue;
            this.charges.put(auraCharge, 0L);
        }
    }
}

