/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.prototype.Container;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.CharacterDataParser;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParsedElement {
    @Nullable
    private final String id;
    @NotNull
    private final AttributeNode attributeNode;
    @NotNull
    private final SVGNode node;
    @NotNull
    private final @NotNull List<@NotNull ParsedElement> children = new ArrayList<ParsedElement>();
    final CharacterDataParser characterDataParser;
    @NotNull
    private BuildStatus buildStatus = BuildStatus.NO;

    ParsedElement(@Nullable String id, @NotNull AttributeNode element, @NotNull SVGNode node) {
        this.id = id;
        this.attributeNode = element;
        this.node = node;
        PermittedContent permittedContent = node.getClass().getAnnotation(PermittedContent.class);
        if (permittedContent == null) {
            throw new IllegalStateException("Element <" + node.tagName() + "> doesn't specify permitted content");
        }
        this.characterDataParser = permittedContent.charData() ? new CharacterDataParser() : null;
    }

    public void registerNamedElement(@NotNull String name, @NotNull Object element) {
        this.attributeNode.namedElements().put(name, element);
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @NotNull
    public List<ParsedElement> children() {
        return this.children;
    }

    @NotNull
    public SVGNode node() {
        return this.node;
    }

    @NotNull
    public SVGNode nodeEnsuringBuildStatus() {
        if (this.buildStatus == BuildStatus.BUILDING) {
            this.warnAboutCyclicDependency();
        } else if (this.buildStatus == BuildStatus.NO) {
            this.build();
        }
        return this.node;
    }

    @NotNull
    public AttributeNode attributeNode() {
        return this.attributeNode;
    }

    void addChild(ParsedElement parsedElement) {
        this.children.add(parsedElement);
        if (this.node instanceof Container) {
            ((Container)((Object)this.node)).addChild(parsedElement.id, parsedElement.node);
        }
    }

    void build() {
        if (this.buildStatus == BuildStatus.YES) {
            return;
        }
        if (this.buildStatus == BuildStatus.BUILDING) {
            this.warnAboutCyclicDependency();
            return;
        }
        this.buildStatus = BuildStatus.BUILDING;
        for (ParsedElement child : this.children) {
            child.build();
        }
        this.node.build(this.attributeNode);
        this.buildStatus = BuildStatus.YES;
    }

    public String toString() {
        return "ParsedElement{node=" + this.node + '}';
    }

    private void warnAboutCyclicDependency() {
        SVGLoader.LOGGER.warning("Cyclic dependency involving node " + this.id + " detected.");
    }

    private static enum BuildStatus {
        NO,
        BUILDING,
        YES;

    }
}

