/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.BlendMode;
import com.github.weisj.jsvg.util.ColorUtil;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class BlendComposite
implements Composite {
    private final BlendMode mode;

    public BlendComposite(BlendMode mode) {
        this.mode = mode;
    }

    public BlendMode blendMode() {
        return this.mode;
    }

    public int hashCode() {
        return this.mode.ordinal();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlendComposite)) {
            return false;
        }
        BlendComposite bc = (BlendComposite)obj;
        return this.mode == bc.mode;
    }

    private static boolean isColorModelInvalid(ColorModel cm) {
        if (cm instanceof DirectColorModel && cm.getTransferType() == 3) {
            DirectColorModel directCM = (DirectColorModel)cm;
            return directCM.getRedMask() != 0xFF0000 || directCM.getGreenMask() != 65280 || directCM.getBlueMask() != 255 || directCM.getNumComponents() == 4 && directCM.getAlphaMask() != -16777216;
        }
        return true;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (BlendComposite.isColorModelInvalid(srcColorModel) || BlendComposite.isColorModelInvalid(dstColorModel)) {
            throw new RasterFormatException("Incompatible color models");
        }
        return new BlendingContext(this.blendMode());
    }

    private static final class BlendingContext
    implements CompositeContext {
        @NotNull
        private final Blender blender;

        private BlendingContext(BlendMode blendMode) {
            this.blender = Blender.forBlendMode(blendMode);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(@NotNull Raster src, @NotNull Raster dstIn, @NotNull WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            int[] result = new int[4];
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int pixel = srcPixels[x];
                    srcPixel[0] = pixel >> 16 & 0xFF;
                    srcPixel[1] = pixel >> 8 & 0xFF;
                    srcPixel[2] = pixel & 0xFF;
                    srcPixel[3] = pixel >> 24 & 0xFF;
                    pixel = dstPixels[x];
                    dstPixel[0] = pixel >> 16 & 0xFF;
                    dstPixel[1] = pixel >> 8 & 0xFF;
                    dstPixel[2] = pixel & 0xFF;
                    dstPixel[3] = pixel >> 24 & 0xFF;
                    this.blender.blend(srcPixel, dstPixel, result);
                    dstPixels[x] = (result[3] & 0xFF) << 24 | (result[0] & 0xFF) << 16 | (result[1] & 0xFF) << 8 | result[2] & 0xFF;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    private static abstract class Blender {
        private Blender() {
        }

        public abstract void blend(int[] var1, int[] var2, int[] var3);

        public static Blender forBlendMode(BlendMode blendMode) {
            switch (blendMode) {
                case Normal: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            if (src[3] == 0) {
                                result[0] = dst[0];
                                result[1] = dst[1];
                                result[2] = dst[2];
                                result[3] = dst[3];
                            } else {
                                result[0] = src[0];
                                result[1] = src[1];
                                result[2] = src[2];
                                result[3] = src[3];
                            }
                        }
                    };
                }
                case Multiply: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = src[0] * dst[0] >> 8;
                            result[1] = src[1] * dst[1] >> 8;
                            result[2] = src[2] * dst[2] >> 8;
                            result[3] = src[3] * dst[3] >> 8;
                        }
                    };
                }
                case Screen: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = 255 - ((255 - src[0]) * (255 - dst[0]) >> 8);
                            result[1] = 255 - ((255 - src[1]) * (255 - dst[1]) >> 8);
                            result[2] = 255 - ((255 - src[2]) * (255 - dst[2]) >> 8);
                            result[3] = 255 - ((255 - src[3]) * (255 - dst[3]) >> 8);
                        }
                    };
                }
                case Overlay: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = dst[0] < 128 ? dst[0] * src[0] >> 7 : 255 - ((255 - dst[0]) * (255 - src[0]) >> 7);
                            result[1] = dst[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - dst[1]) * (255 - src[1]) >> 7);
                            result[2] = dst[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - dst[2]) * (255 - src[2]) >> 7);
                            result[3] = dst[3] < 128 ? dst[3] * src[3] >> 7 : 255 - ((255 - dst[3]) * (255 - src[3]) >> 7);
                        }
                    };
                }
                case Darken: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = Math.min(src[0], dst[0]);
                            result[1] = Math.min(src[1], dst[1]);
                            result[2] = Math.min(src[2], dst[2]);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Lighten: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = Math.max(src[0], dst[0]);
                            result[1] = Math.max(src[1], dst[1]);
                            result[2] = Math.max(src[2], dst[2]);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case ColorDodge: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = src[0] == 255 ? 255 : Math.min((dst[0] << 8) / (255 - src[0]), 255);
                            result[1] = src[1] == 255 ? 255 : Math.min((dst[1] << 8) / (255 - src[1]), 255);
                            result[2] = src[2] == 255 ? 255 : Math.min((dst[2] << 8) / (255 - src[2]), 255);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case ColorBurn: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = src[0] == 0 ? 0 : Math.max(0, 255 - (255 - dst[0] << 8) / src[0]);
                            result[1] = src[1] == 0 ? 0 : Math.max(0, 255 - (255 - dst[1] << 8) / src[1]);
                            result[2] = src[2] == 0 ? 0 : Math.max(0, 255 - (255 - dst[2] << 8) / src[2]);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case HardLight: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = src[0] < 128 ? dst[0] * src[0] >> 7 : 255 - ((255 - src[0]) * (255 - dst[0]) >> 7);
                            result[1] = src[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - src[1]) * (255 - dst[1]) >> 7);
                            result[2] = src[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - src[2]) * (255 - dst[2]) >> 7);
                            result[3] = src[3] < 128 ? dst[3] * src[3] >> 7 : 255 - ((255 - src[3]) * (255 - dst[3]) >> 7);
                        }
                    };
                }
                case SoftLight: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            int mRed = src[0] * dst[0] / 255;
                            int mGreen = src[1] * dst[1] / 255;
                            int mBlue = src[2] * dst[2] / 255;
                            result[0] = mRed + src[0] * (255 - (255 - src[0]) * (255 - dst[0]) / 255 - mRed) / 255;
                            result[1] = mGreen + src[1] * (255 - (255 - src[1]) * (255 - dst[1]) / 255 - mGreen) / 255;
                            result[2] = mBlue + src[2] * (255 - (255 - src[2]) * (255 - dst[2]) / 255 - mBlue) / 255;
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Difference: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = Math.abs(dst[0] - src[0]);
                            result[1] = Math.abs(dst[1] - src[1]);
                            result[2] = Math.abs(dst[2] - src[2]);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Exclusion: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            result[0] = dst[0] + src[0] - (dst[0] * src[0] >> 7);
                            result[1] = dst[1] + src[1] - (dst[1] * src[1] >> 7);
                            result[2] = dst[2] + src[2] - (dst[2] * src[2] >> 7);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Hue: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            float[] srcHSL = new float[3];
                            ColorUtil.RGBtoHSL(src[0], src[1], src[2], srcHSL);
                            float[] dstHSL = new float[3];
                            ColorUtil.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
                            ColorUtil.HSLtoRGB(srcHSL[0], dstHSL[1], dstHSL[2], result);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Saturation: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            float[] srcHSL = new float[3];
                            ColorUtil.RGBtoHSL(src[0], src[1], src[2], srcHSL);
                            float[] dstHSL = new float[3];
                            ColorUtil.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
                            ColorUtil.HSLtoRGB(dstHSL[0], srcHSL[1], dstHSL[2], result);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Color: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            float[] srcHSL = new float[3];
                            ColorUtil.RGBtoHSL(src[0], src[1], src[2], srcHSL);
                            float[] dstHSL = new float[3];
                            ColorUtil.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
                            ColorUtil.HSLtoRGB(srcHSL[0], srcHSL[1], dstHSL[2], result);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
                case Luminosity: {
                    return new Blender(){

                        @Override
                        public void blend(int[] src, int[] dst, int[] result) {
                            float[] srcHSL = new float[3];
                            ColorUtil.RGBtoHSL(src[0], src[1], src[2], srcHSL);
                            float[] dstHSL = new float[3];
                            ColorUtil.RGBtoHSL(dst[0], dst[1], dst[2], dstHSL);
                            ColorUtil.HSLtoRGB(dstHSL[0], dstHSL[1], srcHSL[2], result);
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                        }
                    };
                }
            }
            throw new IllegalStateException("Mode not recognized " + blendMode);
        }
    }
}

