/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util.graphics;

import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JComponent;

public final class GraphicsUtil {
    public static final String DESKTOP_HINTS_KEY = "awt.font.desktophints";
    public static final String KEY_OPAQUE_BUFFERED = "JComponent.opaqueBuffered";

    private GraphicsUtil() {
    }

    public static void setOpaqueBuffered(JComponent c, boolean opaqueBuffered) {
        if (c != null) {
            c.putClientProperty(KEY_OPAQUE_BUFFERED, opaqueBuffered);
        }
    }

    public static boolean isOpaqueBuffered(JComponent c) {
        if (!SystemInfo.isWindows) {
            return false;
        }
        return PropertyUtil.getBooleanProperty(c, KEY_OPAQUE_BUFFERED);
    }

    public static GraphicsContext setupAntialiasing(Graphics g2) {
        return GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static GraphicsContext setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        GraphicsContext config = new GraphicsContext(g2);
        config.setupAntialiasing(enableAA, ignoreSystemSettings);
        return config;
    }

    public static GraphicsContext paintWithAlpha(Graphics g, float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsContext config = new GraphicsContext(g);
        config.setAlpha(alpha);
        return config;
    }

    public static GraphicsContext setupStrokePainting(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsContext context = new GraphicsContext(g2);
        context.setupStrokePainting();
        return context;
    }

    public static boolean isHighDpiEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("hidpi"));
    }

    public static boolean useQuartz() {
        return SystemInfo.isMac && "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    }

    public static boolean supportsTransparency(Window window) {
        if (window == null || GraphicsEnvironment.isHeadless()) {
            return false;
        }
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        if (gc == null) {
            return false;
        }
        return GraphicsUtil.supportsTransparency(gc.getDevice());
    }

    public static boolean supportsTransparency() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return GraphicsUtil.supportsTransparency(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public static boolean supportsTransparency(GraphicsDevice gd) {
        return gd != null && gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT) && gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }
}

