/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton.radiobutton;

import com.github.weisj.darklaf.compatibility.MenuItemLayoutHelper;
import com.github.weisj.darklaf.listener.MouseClickListener;
import com.github.weisj.darklaf.ui.menu.DarkMenuItemUIBase;
import com.github.weisj.darklaf.ui.menu.MenuItemLayoutDelegate;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonMenuItemConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkRadioButtonMenuItemUI
extends DarkMenuItemUIBase
implements ToggleButtonMenuItemConstants {
    private final MouseClickListener clickListener = e -> SwingUtilities.invokeLater(() -> {
        if (this.menuItem != null) {
            this.menuItem.setArmed(true);
        }
    });
    protected MenuItemLayoutDelegate layoutDelegate = new ToggleButtonMenuItemLayoutDelegate(null);
    private Icon stateIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarkRadioButtonMenuItemUI();
    }

    @Override
    public String getPropertyPrefix() {
        return "RadioButtonMenuItem";
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.acceleratorFont = UIManager.getFont("MenuItem.font");
        this.acceleratorForeground = UIManager.getColor("MenuItem.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("MenuItem.selectionForeground");
        this.menuItem.putClientProperty("ToggleButtonMenuItem.doNotCloseOnMouseClick", UIManager.getBoolean("ToggleButtonMenuItem.doNotCloseOnMouseClick"));
        this.installIcons();
        this.checkIcon = this.getStateIcon(this.menuItem);
    }

    protected void installIcons() {
        this.stateIcon = UIManager.getIcon("RadioButton.icon");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.clickListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeMouseListener(this.clickListener);
    }

    @Override
    public MenuItemLayoutHelper getMenuItemLayoutHelper(Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, JMenuItem mi, Rectangle viewRect) {
        if (mi.getIcon() == null) {
            this.layoutDelegate.setDelegate(mi);
            return super.getMenuItemLayoutHelper(null, arrowIcon, defaultTextIconGap, this.layoutDelegate, viewRect);
        }
        return super.getMenuItemLayoutHelper(checkIcon, arrowIcon, defaultTextIconGap, mi, viewRect);
    }

    @Override
    public void paintCheckIcon(Graphics g2, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr, Color foreground) {
        Rectangle rect = lr.getCheckRect();
        if (mi.getIcon() == null) {
            rect.y = lr.getIconRect().y;
            rect.height = lr.getIconRect().height;
        }
        this.getStateIcon(mi).paintIcon(mi, g2, rect.x, rect.y);
    }

    protected Icon getStateIcon(AbstractButton b) {
        return this.stateIcon;
    }

    protected class ToggleButtonMenuItemLayoutDelegate
    extends MenuItemLayoutDelegate {
        public ToggleButtonMenuItemLayoutDelegate(JMenuItem delegate) {
            super(delegate);
        }

        @Override
        public Icon getIcon() {
            return DarkRadioButtonMenuItemUI.this.checkIcon;
        }
    }
}

