/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.listener.AncestorAdapter;
import com.github.weisj.darklaf.properties.color.DarkColorModelCMYK;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSB;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSL;
import com.github.weisj.darklaf.properties.color.DarkColorModelRGB;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.ui.colorchooser.DarkColorChooserPanel;
import com.github.weisj.darklaf.ui.colorchooser.DarkPreviewPanel;
import com.github.weisj.darklaf.ui.colorchooser.DarkSwatchesChooserPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;

public class DarkColorChooserUI
extends BasicColorChooserUI {
    private final PropertyChangeListener layoutPropertyChangeListener = e -> {
        if ("ancestor".equals(e.getPropertyName())) {
            JComponent pane = (JComponent)e.getNewValue();
            if (pane == null) {
                return;
            }
            pane = (JComponent)pane.getRootPane().getContentPane();
            Component[] children = pane.getComponents();
            if (children.length >= 2 && children[1] instanceof JComponent) {
                LayoutManager layout = ((JComponent)children[1]).getLayout();
                if (layout instanceof FlowLayout) {
                    ((FlowLayout)layout).setAlignment(4);
                }
                children[1].doLayout();
            }
        }
    };
    private final AncestorListener ancestorListener = new AncestorAdapter(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            List<Image> imageList;
            Window win = SwingUtilities.getWindowAncestor(DarkColorChooserUI.this.chooser);
            if (win instanceof Dialog) {
                ((Dialog)win).setResizable(false);
                DarkColorChooserUI.this.chooser.removeAncestorListener(DarkColorChooserUI.this.ancestorListener);
            }
            if ((imageList = win.getIconImages()) == null || imageList.isEmpty()) {
                win.setIconImage(IconLoader.createFrameIcon(UIManager.getIcon("ColorChooser.icon"), win));
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkColorChooserUI();
    }

    @Override
    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        return new AbstractColorChooserPanel[]{new DarkColorChooserPanel(DarkColorModelRGB.getInstance(), DarkColorModelHSB.getInstance(), DarkColorModelHSL.getInstance(), DarkColorModelCMYK.getInstance()), new DarkSwatchesChooserPanel()};
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.chooser.setPreviewPanel(new DarkPreviewPanel());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.chooser.addPropertyChangeListener(this.layoutPropertyChangeListener);
        this.chooser.addAncestorListener(this.ancestorListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.chooser.removePropertyChangeListener(this.layoutPropertyChangeListener);
        this.chooser.removeAncestorListener(this.ancestorListener);
    }
}

