/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class StateIcon
implements Icon {
    private final Icon icon;
    private final Icon disabledIcon;
    private final Icon focusedIcon;
    private final Icon selectedIcon;
    private final Icon selectedDisabledIcon;
    private final Icon selectedFocusedIcon;

    public StateIcon(List<Icon> icons) {
        this(icons.toArray(new Icon[0]));
    }

    public StateIcon(Icon[] icons) {
        if (icons == null || icons.length < 6) {
            throw new IllegalArgumentException("Not enough icons given: count=" + (icons == null ? "null" : Integer.valueOf(icons.length)));
        }
        this.icon = icons[0];
        this.disabledIcon = icons[1];
        this.focusedIcon = icons[2];
        this.selectedIcon = icons[3];
        this.selectedDisabledIcon = icons[4];
        this.selectedFocusedIcon = icons[5];
    }

    public StateIcon(Icon icon, Icon disabledIcon, Icon focusedIcon, Icon selectedIcon, Icon selectedDisabledIcon, Icon selectedFocusedIcon) {
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.focusedIcon = focusedIcon;
        this.selectedIcon = selectedIcon;
        this.selectedDisabledIcon = selectedDisabledIcon;
        this.selectedFocusedIcon = selectedFocusedIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIcon(c).paintIcon(c, g, x, y);
    }

    public Icon getIcon(Component c) {
        boolean hasFocus;
        if (!(c instanceof AbstractButton)) {
            return this.icon != null ? this.icon : EmptyIcon.create(0);
        }
        AbstractButton b = (AbstractButton)c;
        boolean selected = b.isSelected();
        boolean enabled = b.isEnabled();
        boolean bl = hasFocus = b.isFocusPainted() && b.hasFocus();
        Icon icn = selected ? (enabled ? (hasFocus ? this.selectedFocusedIcon : this.selectedIcon) : this.selectedDisabledIcon) : (enabled ? (hasFocus ? this.focusedIcon : this.icon) : this.disabledIcon);
        return icn != null ? icn : EmptyIcon.create(0);
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }
}

