/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable.model;

import com.github.weisj.darklaf.components.treetable.model.AbstractTreeTableModel;
import com.github.weisj.darklaf.components.treetable.model.TreeTableModel;
import com.github.weisj.darklaf.components.treetable.model.TreeTableNode;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    private final String[] headers;
    private Class<?>[] columnClasses;

    public DefaultTreeTableModel(TreeTableNode root, String[] headers) {
        super(root);
        this.headers = headers;
    }

    public void setColumnClasses(Class<?>[] columnClasses) {
        this.columnClasses = columnClasses;
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.headers[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        if (this.columnClasses != null && column < this.columnClasses.length) {
            return this.columnClasses[column];
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        TreeTableNode treeTableNode = DarkUIUtil.nullableCast(TreeTableNode.class, node);
        if (treeTableNode == null) {
            return null;
        }
        return treeTableNode.getValueAt(column);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return column != 0;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        TreeTableNode treeTableNode = DarkUIUtil.nullableCast(TreeTableNode.class, node);
        if (treeTableNode != null) {
            treeTableNode.setValueAt(column, aValue);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeTableNode treeTableNode = DarkUIUtil.nullableCast(TreeTableNode.class, parent);
        return treeTableNode != null ? treeTableNode.getChildAt(index) : null;
    }

    @Override
    public int getChildCount(Object parent) {
        TreeTableNode treeTableNode = DarkUIUtil.nullableCast(TreeTableNode.class, parent);
        return treeTableNode != null ? treeTableNode.getChildCount() : 0;
    }
}

