/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import logisticspipes.utils.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public final class SimpleGraphics {
    private SimpleGraphics() {
    }

    public static void drawHorizontalLine(int x1, int x2, int y, Color color, int thickness) {
        SimpleGraphics.drawHorizontalLine(x1, x2, y, Color.getValue(color), thickness);
    }

    public static void drawHorizontalLine(int x1, int x2, int y, int color, int thickness) {
        if (x2 < x1) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        Gui.func_73734_a((int)x1, (int)y, (int)(x2 + 1), (int)(y + thickness), (int)color);
    }

    public static void drawVerticalLine(int x, int y1, int y2, Color color, int thickness) {
        SimpleGraphics.drawVerticalLine(x, y1, y2, Color.getValue(color), thickness);
    }

    public static void drawVerticalLine(int x, int y1, int y2, int color, int thickness) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        Gui.func_73734_a((int)x, (int)(y1 + 1), (int)(x + thickness), (int)y2, (int)color);
    }

    public static void drawRectNoBlend(int x1, int y1, int x2, int y2, Color color, double zLevel) {
        SimpleGraphics.drawRectNoBlend(x1, y1, x2, y2, Color.getValue(color), zLevel);
    }

    public static void drawRectNoBlend(int x1, int y1, int x2, int y2, int color, double zLevel) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)Color.getRed(color), (float)Color.getGreen(color), (float)Color.getBlue(color), (float)Color.getAlpha(color));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, zLevel);
        tessellator.func_78377_a((double)x2, (double)y2, zLevel);
        tessellator.func_78377_a((double)x2, (double)y1, zLevel);
        tessellator.func_78377_a((double)x1, (double)y1, zLevel);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void drawGradientRect(int x1, int y1, int x2, int y2, Color colorA, Color colorB, double zLevel) {
        SimpleGraphics.drawGradientRect(x1, y1, x2, y2, Color.getValue(colorA), Color.getValue(colorB), zLevel);
    }

    public static void drawGradientRect(int x1, int y1, int x2, int y2, int colorA, int colorB, double zLevel) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(Color.getRed(colorA), Color.getGreen(colorA), Color.getBlue(colorA), Color.getAlpha(colorA));
        tessellator.func_78377_a((double)x2, (double)y1, zLevel);
        tessellator.func_78377_a((double)x1, (double)y1, zLevel);
        tessellator.func_78369_a(Color.getRed(colorB), Color.getGreen(colorB), Color.getBlue(colorB), Color.getAlpha(colorB));
        tessellator.func_78377_a((double)x1, (double)y2, zLevel);
        tessellator.func_78377_a((double)x2, (double)y2, zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, (double)((float)u * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, (double)((float)(u + width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public static int drawStringWithTranslatedShadow(FontRenderer fontRenderer, String s, int x, int y, int color) {
        int grayColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        int endX = fontRenderer.func_78276_b(s, x + 1, y + 1, grayColor);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        endX = Math.max(endX, fontRenderer.func_78276_b(s, x, y, color));
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        return endX;
    }

    public static void drawQuad(Tessellator tessellator, int x, int y, int width, int height, Color color, double zLevel) {
        SimpleGraphics.drawQuad(tessellator, x, y, width, height, Color.getValue(color), zLevel);
    }

    public static void drawQuad(Tessellator tessellator, int x, int y, int width, int height, int color, double zLevel) {
        tessellator.func_78382_b();
        tessellator.func_78378_d(color);
        tessellator.func_78377_a((double)x, (double)y, zLevel);
        tessellator.func_78377_a((double)x, (double)(y + height), zLevel);
        tessellator.func_78377_a((double)(x + width), (double)(y + height), zLevel);
        tessellator.func_78377_a((double)(x + width), (double)y, zLevel);
        tessellator.func_78381_a();
    }
}

