/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import net.minecraft.client.Minecraft;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.input.Mouse;

public class WaypointLayer
implements LayerDelegate.Layer {
    private final long hoverDelay = 100L;
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    private final BlockOutlineDrawStep clickDrawStep = new BlockOutlineDrawStep(new BlockCoordIntPair(0, 0));
    BlockCoordIntPair lastCoord = null;
    long lastClick = 0L;
    long startHover = 0L;
    DrawWayPointStep selectedWaypointStep = null;
    Waypoint selected = null;

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!WaypointsData.isManagerEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.drawStepList.clear();
        this.drawStepList.add(this.clickDrawStep);
        if (this.lastCoord == null) {
            this.lastCoord = blockCoord;
        }
        long now = Minecraft.func_71386_F();
        if (!blockCoord.equals(this.clickDrawStep.blockCoord)) {
            this.unclick();
        }
        int proximity = this.getProximity();
        AxisAlignedBB area = ForgeHelper.INSTANCE.getBoundingBox(blockCoord.x - proximity, -1, blockCoord.z - proximity, blockCoord.x + proximity, mc.field_71441_e.func_72940_L() + 1, blockCoord.z + proximity);
        if (!this.lastCoord.equals(blockCoord)) {
            if (!area.func_72318_a(ForgeHelper.INSTANCE.newVec3(this.lastCoord.x, 1.0, this.lastCoord.z))) {
                this.selected = null;
                this.lastCoord = blockCoord;
                this.startHover = now;
                return Collections.EMPTY_LIST;
            }
        } else if (this.selected != null) {
            this.select(this.selected);
            return this.drawStepList;
        }
        if (now - this.startHover < 100L) {
            return Collections.EMPTY_LIST;
        }
        int dimension = mc.field_71439_g.field_71093_bK;
        Collection<Waypoint> waypoints = DataCache.instance().getWaypoints(false);
        ArrayList<Waypoint> proximal = new ArrayList<Waypoint>();
        for (Waypoint waypoint : waypoints) {
            if (waypoint.isReadOnly() || !waypoint.isEnable() || !waypoint.isInPlayerDimension() || !area.func_72318_a(ForgeHelper.INSTANCE.newVec3(waypoint.getX(), waypoint.getY(), waypoint.getZ()))) continue;
            proximal.add(waypoint);
        }
        if (!proximal.isEmpty()) {
            if (proximal.size() > 1) {
                this.sortByDistance(proximal, blockCoord, dimension);
            }
            this.select((Waypoint)proximal.get(0));
        }
        return this.drawStepList;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!WaypointsData.isManagerEnabled()) {
            return Collections.EMPTY_LIST;
        }
        long sysTime = Minecraft.func_71386_F();
        boolean doubleClick = sysTime - this.lastClick < 450L;
        this.lastClick = sysTime;
        if (!this.drawStepList.contains(this.clickDrawStep)) {
            this.drawStepList.add(this.clickDrawStep);
        }
        if (!doubleClick || !blockCoord.equals(this.clickDrawStep.blockCoord)) {
            this.clickDrawStep.blockCoord = blockCoord;
            return this.drawStepList;
        }
        if (this.selected != null) {
            UIManager.getInstance().openWaypointManager(this.selected, new Fullscreen());
            return this.drawStepList;
        }
        Chunk chunk = mc.field_71441_e.func_72964_e(blockCoord.x >> 4, blockCoord.z >> 4);
        int y = -1;
        if (!chunk.func_76621_g()) {
            y = Math.max(1, chunk.func_76626_d(blockCoord.x & 0xF, blockCoord.z & 0xF));
        }
        Waypoint waypoint = Waypoint.at(blockCoord.x, y, blockCoord.z, Waypoint.Type.Normal, mc.field_71439_g.field_71093_bK);
        UIManager.getInstance().openWaypointEditor(waypoint, true, new Fullscreen());
        return this.drawStepList;
    }

    private void sortByDistance(List<Waypoint> waypoints, final BlockCoordIntPair blockCoord, int dimension) {
        Collections.sort(waypoints, new Comparator<Waypoint>(){

            @Override
            public int compare(Waypoint o1, Waypoint o2) {
                return Double.compare(this.getDistance(o1), this.getDistance(o2));
            }

            private double getDistance(Waypoint waypoint) {
                double dx = waypoint.getX() - blockCoord.x;
                double dz = waypoint.getZ() - blockCoord.z;
                return Math.sqrt(dx * dx + dz * dz);
            }
        });
    }

    private void select(Waypoint waypoint) {
        this.selected = waypoint;
        this.selectedWaypointStep = new DrawWayPointStep(waypoint, waypoint.getColor(), 0xFFFFFF, true);
        this.drawStepList.add(this.selectedWaypointStep);
    }

    private int getProximity() {
        FullMapProperties fullMapProperties = JourneymapClient.getFullMapProperties();
        int blockSize = (int)Math.max(1.0, Math.pow(2.0, fullMapProperties.zoomLevel.get()));
        return Math.max(1, 8 / blockSize);
    }

    private void unclick() {
        this.clickDrawStep.blockCoord = new BlockCoordIntPair(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.drawStepList.remove(this.clickDrawStep);
    }

    class BlockOutlineDrawStep
    implements DrawStep {
        BlockCoordIntPair blockCoord;

        BlockOutlineDrawStep(BlockCoordIntPair blockCoord) {
            this.blockCoord = blockCoord;
        }

        @Override
        public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
            if (Mouse.isButtonDown((int)0)) {
                return;
            }
            if (xOffset != 0.0 || yOffset != 0.0) {
                WaypointLayer.this.unclick();
                return;
            }
            double x = this.blockCoord.x;
            double z = this.blockCoord.z;
            double size = Math.pow(2.0, gridRenderer.getZoom());
            double thick = gridRenderer.getZoom() < 2 ? 1.0 : 2.0;
            Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
            pixel.setLocation(pixel.getX() + xOffset, pixel.getY() + yOffset);
            if (gridRenderer.isOnScreen(pixel)) {
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() - thick * thick, size + thick * 4.0, thick, 0, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY() - thick, size + thick * thick, thick, 0xFFFFFF, 255);
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() - thick, thick, size + thick * thick, 0, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY(), thick, size, 0xFFFFFF, 255);
                DrawUtil.drawRectangle(pixel.getX() + size, pixel.getY(), thick, size, 0xFFFFFF, 255);
                DrawUtil.drawRectangle(pixel.getX() + size + thick, pixel.getY() - thick, thick, size + thick * thick, 0, 150);
                DrawUtil.drawRectangle(pixel.getX() - thick, pixel.getY() + size, size + thick * thick, thick, 0xFFFFFF, 255);
                DrawUtil.drawRectangle(pixel.getX() - thick * thick, pixel.getY() + size + thick, size + thick * 4.0, thick, 0, 150);
            }
        }
    }
}

