/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.JMLogger;
import journeymap.client.model.GridSpecs;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.properties.config.Config;
import journeymap.client.task.multi.RenderSpec;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class CoreProperties
extends PropertiesBase
implements Comparable<CoreProperties> {
    @Config(category=Config.Category.Advanced, key="jm.advanced.loglevel", stringListProvider=JMLogger.LogLevelStringProvider.class)
    public final AtomicReference<String> logLevel = new AtomicReference<String>("INFO");
    @Config(category=Config.Category.Advanced, key="jm.advanced.automappoll", minValue=500.0, maxValue=10000.0, defaultValue=2000.0)
    public final AtomicInteger autoMapPoll = new AtomicInteger(2000);
    @Config(category=Config.Category.Advanced, key="jm.advanced.cache_animals", minValue=1000.0, maxValue=10000.0, defaultValue=3100.0)
    public final AtomicInteger cacheAnimalsData = new AtomicInteger(3100);
    @Config(category=Config.Category.Advanced, key="jm.advanced.cache_mobs", minValue=1000.0, maxValue=10000.0, defaultValue=3000.0)
    public final AtomicInteger cacheMobsData = new AtomicInteger(3000);
    @Config(category=Config.Category.Advanced, key="jm.advanced.cache_player", minValue=500.0, maxValue=2000.0, defaultValue=1000.0)
    public final AtomicInteger cachePlayerData = new AtomicInteger(1000);
    @Config(category=Config.Category.Advanced, key="jm.advanced.cache_players", minValue=1000.0, maxValue=10000.0, defaultValue=2000.0)
    public final AtomicInteger cachePlayersData = new AtomicInteger(2000);
    @Config(category=Config.Category.Advanced, key="jm.advanced.cache_villagers", minValue=1000.0, maxValue=10000.0, defaultValue=2200.0)
    public final AtomicInteger cacheVillagersData = new AtomicInteger(2200);
    @Config(category=Config.Category.Advanced, key="jm.advanced.announcemod", defaultBoolean=true)
    public final AtomicBoolean announceMod = new AtomicBoolean(true);
    @Config(category=Config.Category.Advanced, key="jm.advanced.checkupdates", defaultBoolean=true)
    public final AtomicBoolean checkUpdates = new AtomicBoolean(true);
    @Config(category=Config.Category.Advanced, key="jm.advanced.recordcachestats", defaultBoolean=false)
    public final AtomicBoolean recordCacheStats = new AtomicBoolean(false);
    @Config(category=Config.Category.Advanced, key="jm.advanced.browserpoll", minValue=1000.0, maxValue=10000.0, defaultValue=2000.0)
    public final AtomicInteger browserPoll = new AtomicInteger(2000);
    @Config(category=Config.Category.FullMap, key="jm.common.ui_theme", stringListProvider=ThemeFileHandler.ThemeStringListProvider.class)
    public final AtomicReference<String> themeName = new AtomicReference<String>(new ThemeFileHandler.ThemeStringListProvider().getDefaultString());
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_caveignoreglass", defaultBoolean=true)
    public final AtomicBoolean caveIgnoreGlass = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_bathymetry", defaultBoolean=false)
    public final AtomicBoolean mapBathymetry = new AtomicBoolean(false);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_transparency", defaultBoolean=true)
    public final AtomicBoolean mapTransparency = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_cavelighting", defaultBoolean=true)
    public final AtomicBoolean mapCaveLighting = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_antialiasing", defaultBoolean=true)
    public final AtomicBoolean mapAntialiasing = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_plantshadows", defaultBoolean=false)
    public final AtomicBoolean mapPlantShadows = new AtomicBoolean(false);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_plants", defaultBoolean=false)
    public final AtomicBoolean mapPlants = new AtomicBoolean(false);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_crops", defaultBoolean=true)
    public final AtomicBoolean mapCrops = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.map_style_caveshowsurface", defaultBoolean=true)
    public final AtomicBoolean mapSurfaceAboveCaves = new AtomicBoolean(true);
    @Config(category=Config.Category.Cartography, key="jm.common.renderdistance_cave_min", minValue=1.0, maxValue=32.0, defaultValue=3.0, sortOrder=101)
    public final AtomicInteger renderDistanceCaveMin = new AtomicInteger(3);
    @Config(category=Config.Category.Cartography, key="jm.common.renderdistance_cave_max", minValue=1.0, maxValue=32.0, defaultValue=3.0, sortOrder=102)
    public final AtomicInteger renderDistanceCaveMax = new AtomicInteger(3);
    @Config(category=Config.Category.Cartography, key="jm.common.renderdistance_surface_min", minValue=1.0, maxValue=32.0, defaultValue=4.0, sortOrder=103)
    public final AtomicInteger renderDistanceSurfaceMin = new AtomicInteger(4);
    @Config(category=Config.Category.Cartography, key="jm.common.renderdistance_surface_max", minValue=1.0, maxValue=32.0, defaultValue=7.0, sortOrder=104)
    public final AtomicInteger renderDistanceSurfaceMax = new AtomicInteger(7);
    @Config(category=Config.Category.Cartography, key="jm.common.renderdelay", minValue=0.0, maxValue=10.0, defaultValue=2.0)
    public final AtomicInteger renderDelay = new AtomicInteger(2);
    @Config(category=Config.Category.Cartography, key="jm.common.revealshape", defaultEnum="Circle")
    public final AtomicReference<RenderSpec.RevealShape> revealShape = new AtomicReference<RenderSpec.RevealShape>(RenderSpec.RevealShape.Circle);
    @Config(category=Config.Category.Cartography, key="jm.common.alwaysmapcaves", defaultBoolean=false)
    public final AtomicBoolean alwaysMapCaves = new AtomicBoolean();
    @Config(category=Config.Category.Cartography, key="jm.common.alwaysmapsurface", defaultBoolean=false)
    public final AtomicBoolean alwaysMapSurface = new AtomicBoolean();
    @Config(category=Config.Category.Cartography, key="jm.common.tile_display_quality", defaultBoolean=true)
    public final AtomicBoolean tileHighDisplayQuality = new AtomicBoolean(true);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_max_animals", minValue=1.0, maxValue=128.0, defaultValue=32.0)
    public final AtomicInteger maxAnimalsData = new AtomicInteger(32);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_max_mobs", minValue=1.0, maxValue=128.0, defaultValue=32.0)
    public final AtomicInteger maxMobsData = new AtomicInteger(32);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_max_players", minValue=1.0, maxValue=128.0, defaultValue=32.0)
    public final AtomicInteger maxPlayersData = new AtomicInteger(32);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_max_villagers", minValue=1.0, maxValue=128.0, defaultValue=32.0)
    public final AtomicInteger maxVillagersData = new AtomicInteger(32);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_hide_sneaking", defaultBoolean=true)
    public final AtomicBoolean hideSneakingEntities = new AtomicBoolean(true);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_lateral_distance", minValue=16.0, maxValue=512.0, defaultValue=64.0)
    public final AtomicInteger radarLateralDistance = new AtomicInteger(64);
    @Config(category=Config.Category.Advanced, key="jm.common.radar_vertical_distance", minValue=8.0, maxValue=256.0, defaultValue=16.0)
    public final AtomicInteger radarVerticalDistance = new AtomicInteger(16);
    @Config(category=Config.Category.Advanced, key="jm.advanced.tile_render_type", minValue=1.0, maxValue=4.0, defaultValue=1.0)
    public final AtomicInteger tileRenderType = new AtomicInteger(1);
    public final GridSpecs gridSpecs = new GridSpecs();
    public final AtomicBoolean mappingEnabled = new AtomicBoolean(true);
    public final AtomicReference<String> renderOverlayEventTypeName = new AtomicReference<String>(RenderGameOverlayEvent.ElementType.ALL.name());
    public final AtomicBoolean renderOverlayPreEvent = new AtomicBoolean(true);
    public final AtomicReference<String> optionsManagerViewed = new AtomicReference<String>("");
    public final AtomicReference<String> splashViewed = new AtomicReference<String>("");
    protected final transient String name = "core";

    @Override
    public String getName() {
        return "core";
    }

    @Override
    public int compareTo(CoreProperties other) {
        return Integer.valueOf(this.hashCode()).compareTo(other.hashCode());
    }

    public RenderGameOverlayEvent.ElementType getRenderOverlayEventType() {
        return Enum.valueOf(RenderGameOverlayEvent.ElementType.class, this.renderOverlayEventTypeName.get());
    }

    @Override
    protected boolean validate() {
        boolean saveNeeded = super.validate();
        if (this.renderDistanceCaveMax.get() < this.renderDistanceCaveMin.get()) {
            this.renderDistanceCaveMax.set(this.renderDistanceCaveMin.get());
            saveNeeded = true;
        }
        if (this.renderDistanceSurfaceMax.get() < this.renderDistanceSurfaceMin.get()) {
            this.renderDistanceSurfaceMax.set(this.renderDistanceSurfaceMin.get());
            saveNeeded = true;
        }
        int gameRenderDistance = ForgeHelper.INSTANCE.getClient().field_71474_y.field_151451_c;
        for (AtomicInteger prop : Arrays.asList(this.renderDistanceCaveMin, this.renderDistanceCaveMax, this.renderDistanceSurfaceMin, this.renderDistanceSurfaceMax)) {
            if (prop.get() <= gameRenderDistance) continue;
            prop.set(gameRenderDistance);
            saveNeeded = true;
        }
        return saveNeeded;
    }

    public boolean hasValidCaveRenderDistances() {
        return this.renderDistanceCaveMax.get() >= this.renderDistanceCaveMin.get();
    }

    public boolean hasValidSurfaceRenderDistances() {
        return this.renderDistanceSurfaceMax.get() >= this.renderDistanceSurfaceMin.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreProperties that = (CoreProperties)o;
        return 0 == that.compareTo(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.announceMod, this.autoMapPoll, this.browserPoll, this.cacheAnimalsData, this.cacheMobsData, this.cachePlayerData, this.cachePlayersData, this.cacheVillagersData, this.caveIgnoreGlass, this.checkUpdates, this.renderDelay, this.hideSneakingEntities, this.logLevel, this.mapAntialiasing, this.mapBathymetry, this.mapCaveLighting, this.mapCrops, this.mapPlants, this.mapPlantShadows, this.mapSurfaceAboveCaves, this.mapTransparency, this.maxAnimalsData, this.maxMobsData, this.maxPlayersData, this.maxVillagersData, "core", this.radarLateralDistance, this.radarVerticalDistance, this.recordCacheStats, this.renderOverlayEventTypeName, this.renderOverlayPreEvent, this.renderDistanceCaveMin, this.renderDistanceCaveMax, this.renderDistanceSurfaceMin, this.renderDistanceSurfaceMax, this.revealShape, this.themeName, this.gridSpecs});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("announceMod", (Object)this.announceMod).add("autoMapPoll", (Object)this.autoMapPoll).add("browserPoll", (Object)this.browserPoll).add("cacheAnimalsData", (Object)this.cacheAnimalsData).add("cacheMobsData", (Object)this.cacheMobsData).add("cachePlayerData", (Object)this.cachePlayerData).add("cachePlayersData", (Object)this.cachePlayersData).add("cacheVillagersData", (Object)this.cacheVillagersData).add("caveIgnoreGlass", (Object)this.caveIgnoreGlass).add("isUpdateCheckEnabled", (Object)this.checkUpdates).add("renderDelay", (Object)this.renderDelay).add("hideSneakingEntities", (Object)this.hideSneakingEntities).add("logLevel", this.logLevel).add("mapAntialiasing", (Object)this.mapAntialiasing).add("mapBathymetry", (Object)this.mapBathymetry).add("mapCaveLighting", (Object)this.mapCaveLighting).add("mapCrops", (Object)this.mapCrops).add("mapPlants", (Object)this.mapPlants).add("mapPlantShadows", (Object)this.mapPlantShadows).add("mapSurfaceAboveCaves", (Object)this.mapSurfaceAboveCaves).add("tileHighDisplayQuality", (Object)this.tileHighDisplayQuality).add("mapTransparency", (Object)this.mapTransparency).add("maxAnimalsData", (Object)this.maxAnimalsData).add("maxMobsData", (Object)this.maxMobsData).add("maxPlayersData", (Object)this.maxPlayersData).add("maxVillagersData", (Object)this.maxVillagersData).add("optionsManagerViewed", this.optionsManagerViewed).add("radarLateralDistance", (Object)this.radarLateralDistance).add("radarVerticalDistance", (Object)this.radarVerticalDistance).add("recordCacheStats", (Object)this.recordCacheStats).add("renderOverlayEventTypeName", this.renderOverlayEventTypeName).add("renderOverlayPreEvent", (Object)this.renderOverlayPreEvent).add("renderDistanceCaveMin", (Object)this.renderDistanceCaveMin).add("renderDistanceCaveMax", (Object)this.renderDistanceCaveMax).add("renderDistanceSurfaceMin", (Object)this.renderDistanceSurfaceMin).add("renderDistanceSurfaceMax", (Object)this.renderDistanceSurfaceMax).add("revealShape", this.revealShape).add("themeName", this.themeName).add("tileRenderType", (Object)this.tileRenderType).toString();
    }
}

