/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksObfuscation;
import invtweaks.api.IItemTreeItem;
import org.apache.commons.lang3.ObjectUtils;

public class InvTweaksItemTreeItem
implements IItemTreeItem {
    private String name;
    private String id;
    private int damageMin;
    private int damageMax;
    private int order;

    public InvTweaksItemTreeItem(String name, String id, int damage, int order) {
        this.name = name;
        this.id = InvTweaksObfuscation.getNamespacedID(id);
        this.damageMin = damage;
        this.damageMax = damage;
        this.order = order;
    }

    public InvTweaksItemTreeItem(String name, String id, int damageMin, int damageMax, int order) {
        this.name = name;
        this.id = InvTweaksObfuscation.getNamespacedID(id);
        this.damageMin = damageMin;
        this.damageMax = damageMax;
        this.order = order;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getDamage() {
        return this.damageMin;
    }

    @Override
    public boolean matchesDamage(int damage) {
        if (damage == Short.MAX_VALUE || this.damageMin == Short.MAX_VALUE || this.damageMax == Short.MAX_VALUE) {
            return true;
        }
        return damage >= this.damageMin && damage <= this.damageMax;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IItemTreeItem)) {
            return false;
        }
        IItemTreeItem item = (IItemTreeItem)o;
        return ObjectUtils.equals((Object)this.id, (Object)item.getId()) && (this.damageMin == Short.MAX_VALUE || this.damageMin <= item.getDamage() && this.damageMax >= item.getDamage());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(IItemTreeItem item) {
        return item.getOrder() - this.getOrder();
    }
}

