/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.pam.harvestcraft.BlockRegistry;
import com.pam.harvestcraft.base.BlockGarden;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GardenRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), "harvestcraftGardenDrops", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("harvestcraftGardenDrops") && ((Object)((Object)this)).getClass() == GardenRecipeHandler.class) {
            this.arecipes.addAll(this.getRecipes());
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<GardenRecipe> recipes = this.getRecipes();
        for (GardenRecipe recipe : recipes) {
            if (!recipe.hasOutput(result)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<GardenRecipe> recipes = this.getRecipes();
        for (GardenRecipe recipe : recipes) {
            if (!recipe.hasInput(ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "harvestcraft:textures/gui/gardenNEI.png";
    }

    public String getOverlayIdentifier() {
        return "harvestcraftGardenDrops";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"harvestcraft.nei.garden.category", (Object[])new Object[0]);
    }

    public void drawExtras(int recipeIndex) {
        String biomeTransKey = ((GardenRecipe)((Object)this.arecipes.get(recipeIndex))).getBiomeTransKey();
        String textToDraw = I18n.func_135052_a((String)"harvestcraft.nei.garden.found", (Object[])new Object[]{I18n.func_135052_a((String)biomeTransKey, (Object[])new Object[0])});
        int y = 78;
        for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
            GuiDraw.drawString((String)((String)text), (int)2, (int)y, (int)0, (boolean)false);
            y += 11;
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)100);
    }

    private List<GardenRecipe> getRecipes() {
        ArrayList<GardenRecipe> recipes = new ArrayList<GardenRecipe>();
        HashMap<String, Block> gardens = new HashMap<String, Block>();
        gardens.put("harvestcraft.nei.garden.berry", BlockRegistry.pamberryGarden);
        gardens.put("harvestcraft.nei.garden.desert", BlockRegistry.pamdesertGarden);
        gardens.put("harvestcraft.nei.garden.grass", BlockRegistry.pamgrassGarden);
        gardens.put("harvestcraft.nei.garden.gourd", BlockRegistry.pamgourdGarden);
        gardens.put("harvestcraft.nei.garden.ground", BlockRegistry.pamgroundGarden);
        gardens.put("harvestcraft.nei.garden.herb", BlockRegistry.pamherbGarden);
        gardens.put("harvestcraft.nei.garden.leafy", BlockRegistry.pamleafyGarden);
        gardens.put("harvestcraft.nei.garden.mushroom", BlockRegistry.pammushroomGarden);
        gardens.put("harvestcraft.nei.garden.stalk", BlockRegistry.pamstalkGarden);
        gardens.put("harvestcraft.nei.garden.textile", BlockRegistry.pamtextileGarden);
        gardens.put("harvestcraft.nei.garden.tropical", BlockRegistry.pamtropicalGarden);
        gardens.put("harvestcraft.nei.garden.water", BlockRegistry.pamwaterGarden);
        gardens.put("harvestcraft.nei.garden.nether", GameRegistry.findBlock((String)"harvestthenether", (String)"netherGarden"));
        for (Map.Entry garden : gardens.entrySet()) {
            String biomeTransKey = (String)garden.getKey();
            Block gardenBlock = (Block)garden.getValue();
            if (gardenBlock == null) continue;
            List<ItemStack> outputs = BlockGarden.getDropList(gardenBlock).stream().map(item -> new ItemStack(item, 1)).collect(Collectors.toList());
            recipes.add(new GardenRecipe(new ItemStack(gardenBlock), outputs, biomeTransKey));
        }
        return recipes;
    }

    public class GardenRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private final String biomeTransKey;

        public GardenRecipe(ItemStack garden, List<ItemStack> outputs, String biomeTransKey) {
            super((TemplateRecipeHandler)GardenRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.input.add(new PositionedStack((Object)garden, 74, 4));
            int row = 0;
            int col = 0;
            for (ItemStack output : outputs) {
                this.outputs.add(new PositionedStack((Object)output, 3 + 18 * col, 37 + 18 * row));
                if (++col <= 8) continue;
                col = 0;
                ++row;
            }
            this.biomeTransKey = biomeTransKey;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        protected String getBiomeTransKey() {
            return this.biomeTransKey;
        }

        protected boolean hasOutput(ItemStack stack) {
            for (PositionedStack outputStack : this.outputs) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)outputStack.item, (ItemStack)stack)) continue;
                return true;
            }
            return false;
        }

        protected boolean hasInput(ItemStack stack) {
            for (PositionedStack outputStack : this.input) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)outputStack.item, (ItemStack)stack)) continue;
                return true;
            }
            return false;
        }
    }
}

