/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.enderStorage;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class EnderLinkTag
implements Serializable {
    private static final long serialVersionUID = 6884008436570077863L;
    private final String frequency;
    private final UUID player;

    public EnderLinkTag(String frequency, UUID player) {
        this.frequency = frequency;
        this.player = player;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public UUID getUUID() {
        return this.player;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnderLinkTag that = (EnderLinkTag)o;
        return Objects.equal((Object)this.frequency, (Object)that.frequency) && Objects.equal((Object)this.player, (Object)that.player);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.frequency, this.player});
    }

    public NBTTagCompound save() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("Freq", this.frequency);
        if (this.player != null) {
            data.func_74772_a("ID1", this.player.getLeastSignificantBits());
            data.func_74772_a("ID2", this.player.getMostSignificantBits());
        }
        return data;
    }

    public static EnderLinkTag load(NBTTagCompound data) {
        String freq = data.func_74779_i("Freq");
        UUID player = data.func_74764_b("ID1") ? new UUID(data.func_74763_f("ID2"), data.func_74763_f("ID1")) : null;
        return new EnderLinkTag(freq, player);
    }
}

