/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.plugin.agrichem.BioRecipes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RecipeLoaderGlueLine {
    public static void generate() {
        RecipeLoaderGlueLine.createRecipes();
    }

    private static void createRecipes() {
        RecipeLoaderGlueLine.chemicalPlantRecipes();
        RecipeLoaderGlueLine.chemicalReactorRecipes();
        RecipeLoaderGlueLine.dehydratorRecipes();
        RecipeLoaderGlueLine.distillationTowerRecipes();
        RecipeLoaderGlueLine.fluidHeaterRecipes();
        RecipeLoaderGlueLine.mixerRecipes();
        RecipeLoaderGlueLine.glueUsageRecipes();
    }

    private static void chemicalPlantRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemUtils.getSimpleStack(GenericChem.mBlueCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack("carbonmonoxide", 1000), FluidUtils.getFluidStack("methylacetate", 1000)).fluidOutputs(MaterialMisc.ACETIC_ANHYDRIDE.getFluidStack(1000)).duration(200).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(18)).fluidInputs(FluidUtils.getFluidStack("aceticacid", 1000), FluidUtils.getFluidStack("chlorine", 1000), MaterialMisc.ACETIC_ANHYDRIDE.getFluidStack(1000)).fluidOutputs(MaterialMisc.CHLOROACETIC_MIXTURE.getFluidStack(1000), MaterialMisc.ACETIC_ANHYDRIDE.getFluidStack(950)).duration(3000).eut(1000).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(19), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), MaterialMisc.SODIUM_CYANIDE.getDust(3)).itemOutputs(MaterialMisc.CYANOACETIC_ACID.getDust(9), Materials.Salt.getDust(6)).fluidInputs(MaterialMisc.CHLOROACETIC_ACID.getFluidStack(1000), FluidUtils.getFluidStack("hydrochloricacid_gt5u", 2000)).fluidOutputs(Materials.CarbonDioxide.getGas(1000L), GTModHandler.getWater(1000L)).duration(400).eut(1000).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20), ItemUtils.getSimpleStack(GenericChem.mSolidAcidCatalyst, 0), MaterialMisc.COPPER_SULFATE.getDust(6), MaterialMisc.CYANOACETIC_ACID.getDust(45)).itemOutputs(MaterialMisc.COPPER_SULFATE_HYDRATED.getDust(11)).fluidInputs(Materials.Ethanol.getFluid(5000L)).fluidOutputs(MaterialMisc.ETHYL_CYANOACETATE.getFluidStack(5000)).duration(10000).eut(6000).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 5).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(21), MaterialMisc.CYANOACETIC_ACID.getDust(9)).fluidInputs(Materials.Ethanol.getFluid(1000L)).fluidOutputs(MaterialMisc.ETHYL_CYANOACETATE.getFluidStack(1000)).duration(20000).eut(6000).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 5).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        BioRecipes.mFormaldehyde = FluidUtils.getFluidStack("fluid.formaldehyde", 1).getFluid();
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(22), ItemUtils.getSimpleStack(GenericChem.mSolidAcidCatalyst, 0)).fluidInputs(MaterialMisc.ETHYL_CYANOACETATE.getFluidStack(100), FluidUtils.getFluidStack(BioRecipes.mFormaldehyde, 100)).fluidOutputs(MaterialMisc.CYANOACRYLATE_POLYMER.getFluidStack(100), FluidUtils.getWater(1000)).duration(200).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 5).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(23), ItemUtils.getSimpleStack(GenericChem.mPinkCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack("methane", 2000), FluidUtils.getFluidStack("ammonia", 2000), FluidUtils.getFluidStack("oxygen", 6000)).fluidOutputs(MaterialMisc.HYDROGEN_CYANIDE.getFluidStack(2000), FluidUtils.getWater(6000)).duration(200).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void chemicalReactorRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 3)).itemOutputs(MaterialMisc.SODIUM_CYANIDE.getDust(3)).fluidInputs(MaterialMisc.HYDROGEN_CYANIDE.getFluidStack(1000)).fluidOutputs(FluidUtils.getWater(1000)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 3)).itemOutputs(MaterialMisc.SODIUM_CYANIDE.getDust(3)).fluidInputs(MaterialMisc.HYDROGEN_CYANIDE.getFluidStack(1000)).fluidOutputs(FluidUtils.getWater(1000)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 5), GTUtility.getIntegratedCircuit(8)).itemOutputs(ItemUtils.getItemStackFromFQRN("bartworks:gt.bwMetaGenerateddust:63", 3)).fluidInputs(Materials.HydrochloricAcid.getFluid(2000L)).fluidOutputs(Materials.CarbonDioxide.getGas(1000L)).duration(100).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1)).itemOutputs(MaterialMisc.COPPER_SULFATE.getDust(6)).fluidInputs(FluidUtils.getFluidStack("sulfuricacid", 2000)).fluidOutputs(FluidUtils.getFluidStack("dilutedsulfuricacid", 1000)).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1)).itemOutputs(MaterialMisc.COPPER_SULFATE.getDust(6)).fluidInputs(FluidUtils.getFluidStack("sulfuricacid", 2000)).fluidOutputs(FluidUtils.getFluidStack("dilutedsulfuricacid", 1000)).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
    }

    private static void dehydratorRecipes() {
        GTValues.RA.stdBuilder().itemInputs(MaterialMisc.COPPER_SULFATE_HYDRATED.getDust(11)).itemOutputs(MaterialMisc.COPPER_SULFATE.getDust(6)).fluidOutputs(GTModHandler.getWater(5000L)).eut(10).duration(6000).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private static void distillationTowerRecipes() {
        GTValues.RA.stdBuilder().fluidInputs(MaterialMisc.CHLOROACETIC_MIXTURE.getFluidStack(1000)).fluidOutputs(MaterialMisc.CHLOROACETIC_ACID.getFluidStack(100), MaterialMisc.DICHLOROACETIC_ACID.getFluidStack(450), MaterialMisc.TRICHLOROACETIC_ACID.getFluidStack(450)).duration(80).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.distillationTowerRecipes);
    }

    private static void fluidHeaterRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(16)).fluidInputs(MaterialMisc.CYANOACRYLATE_POLYMER.getFluidStack(100)).fluidOutputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(100)).duration(900).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidHeaterRecipes);
    }

    private static void mixerRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1), MaterialMisc.DICHLOROACETIC_ACID.getCell(1)).itemOutputs(CI.emptyCells(1)).fluidInputs(MaterialMisc.TRICHLOROACETIC_ACID.getFluidStack(1000)).fluidOutputs(MaterialMisc.CHLOROACETIC_MIXTURE.getFluidStack(2000)).duration(100).eut(100).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurTrioxide", 1), GTUtility.getIntegratedCircuit(2)).itemOutputs(CI.emptyCells(1)).fluidInputs(FluidUtils.getFluidStack("sulfuricacid", 1000)).fluidOutputs(MaterialMisc.SOLID_ACID_MIXTURE.getFluidStack(1000)).duration(100).eut(40).addTo(RecipeMaps.mixerRecipes);
    }

    private static void glueUsageRecipes() {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, Materials.Polybenzimidazole, 1L), GTModHandler.getIC2Item("carbonMesh", 1L), GTUtility.getIntegratedCircuit(10)).itemOutputs(ItemList.Duct_Tape.get(16L, new Object[0])).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(100)).duration(120).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Hull_LV.get(1L, new Object[0]), ItemList.Duct_Tape.get(1L, new Object[0]), GTUtility.getIntegratedCircuit(1)).itemOutputs(ItemList.Hatch_Maintenance.get(1L, new Object[0])).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(100)).duration(120).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustGraphite", 64), ItemList.Circuit_Silicon_Wafer4.get(2L, new Object[0]), GTUtility.getIntegratedCircuit(2)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustGraphene", 64)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(500)).duration(400).eut(TierEU.RECIPE_LuV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustGraphite", 64), ItemList.Circuit_Silicon_Wafer5.get(1L, new Object[0]), GTUtility.getIntegratedCircuit(2)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustGraphene", 64)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(250)).duration(80).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sulfur, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Wood, 4L), GTUtility.getIntegratedCircuit(1)).itemOutputs(ItemList.SFMixture.get(32L, new Object[0])).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(100)).duration(1600).eut(16).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.GelledToluene.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Aluminium, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Polybenzimidazole, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(ItemList.SFMixture.get(64L, new Object[0])).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(100)).duration(1600).eut(16).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.foil, Materials.PolyvinylChloride, 8L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Paper, 32L)).itemOutputs(new ItemStack(Items.field_151122_aG, 64, 0)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(200)).duration(32).eut(8).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt01, Materials.Naquadah, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.RedSteel, 18L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32505", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(144)).duration(300).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt01, Materials.NaquadahAlloy, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Europium, 6L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32506", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(288)).duration(200).eut(TierEU.RECIPE_LuV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt01, Materials.ElectrumFlux, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Americium, 18L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32507", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(576)).duration(300).eut(TierEU.RECIPE_ZPM).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt02, Materials.ElectrumFlux, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Naquadah, 24L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32561", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(1152)).duration(100).eut(TierEU.RECIPE_UV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt04, Materials.ElectrumFlux, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.NaquadahEnriched, 36L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32562", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(2304)).duration(200).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cableGt08, Materials.ElectrumFlux, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.NaquadahAlloy, 48L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32563", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(4608)).duration(300).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.wireGt16, Materials.SuperconductorUHV, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Neutronium, 56L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32564", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(9216)).duration(600).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.wireGt16, Materials.SuperconductorUHV, 2L), GTOreDictUnificator.get(OrePrefixes.plate, Materials.DraconiumAwakened, 64L)).itemOutputs(ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32565", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(18432)).duration(1200).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.assemblerRecipes);
        if (Mods.NewHorizonsCoreMod.isModLoaded() && Mods.GalacticraftCore.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackFromFQRN("GalacticraftMars:item.itemBasicAsteroids:7", 1), GTOreDictUnificator.get(OrePrefixes.foil, Materials.Titanium, 8L), ItemUtils.getItemStackFromFQRN("dreamcraft:item.TungstenString", 8), GTUtility.getIntegratedCircuit(1)).itemOutputs(ItemUtils.getItemStackFromFQRN("GalaxySpace:item.ThermalClothT2", 1)).fluidInputs(MaterialMisc.ETHYL_CYANOACRYLATE.getFluidStack(576)).duration(600).eut(1024).addTo(RecipeMaps.assemblerRecipes);
        }
    }
}

