/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGenAssembler
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenAssembler(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{material.getRod(1), material.getFrameBox(1)})) {
            GTValues.RA.stdBuilder().itemInputs(material.getRod(4), GTUtility.getIntegratedCircuit(4)).itemOutputs(material.getFrameBox(1)).duration(60).eut(material.vVoltageMultiplier).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{material.getPlate(1), material.getRing(1), material.getRotor(1)})) {
            RecipeGenAssembler.addAssemblerRecipe(material.getPlate(4), material.getRing(1), material.getRotor(1), 240, material.vVoltageMultiplier);
        }
    }

    @Deprecated
    private static void addAssemblerRecipe(ItemStack input1, ItemStack input2, ItemStack output1, int seconds, int euCost) {
        GTValues.RA.stdBuilder().itemInputs(input1, input2).itemOutputs(output1).fluidInputs(FluidUtils.getFluidStack("molten.solderingalloy", 16)).duration(seconds).eut(euCost).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(input1, input2).itemOutputs(output1).fluidInputs(FluidUtils.getFluidStack("molten.tin", 32)).duration(seconds).eut(euCost).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(input1, input2).itemOutputs(output1).fluidInputs(FluidUtils.getFluidStack("molten.lead", 48)).duration(seconds).eut(euCost).addTo(RecipeMaps.assemblerRecipes);
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

