/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.util.Utils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class PlayerUtils {
    public static List<EntityPlayerMP> getOnlinePlayers() {
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
    }

    public static void messagePlayer(EntityPlayer P, String S) {
        GTUtility.sendChatToPlayer(P, S);
    }

    public static void messagePlayer(EntityPlayer P, IChatComponent S) {
        P.func_146105_b(S);
    }

    public static EntityPlayer getPlayer(String name) {
        try {
            for (EntityPlayer entityPlayer : PlayerUtils.getOnlinePlayers()) {
                if (!entityPlayer.getDisplayName().equalsIgnoreCase(name)) continue;
                return entityPlayer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static EntityPlayer getPlayerOnServerFromUUID(UUID parUUID) {
        if (parUUID == null) {
            return null;
        }
        for (EntityPlayerMP player : PlayerUtils.getOnlinePlayers()) {
            if (!player.func_110124_au().equals(parUUID)) continue;
            return player;
        }
        return null;
    }

    public static boolean isPlayerOP(EntityPlayer player) {
        return player.func_70003_b(2, "");
    }

    public static ItemStack getItemStackInPlayersHand(World world, String Name2) {
        return PlayerUtils.getItemStackInPlayersHand(PlayerUtils.getPlayer(Name2));
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getItemStackInPlayersHand() {
        return PlayerUtils.getItemStackInPlayersHand((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public static ItemStack getItemStackInPlayersHand(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return player.func_70694_bm();
    }

    public static UUID getPlayersUUIDByName(String aPlayerName) {
        EntityPlayer player = PlayerUtils.getPlayer(aPlayerName);
        if (player != null) {
            return player.func_110124_au();
        }
        return null;
    }

    public static void messageAllPlayers(String string) {
        Utils.sendServerMessage(string);
    }

    public static boolean isCreative(EntityPlayer aPlayer) {
        return aPlayer.field_71075_bZ.field_75098_d;
    }

    public static boolean canTakeDamage(EntityPlayer aPlayer) {
        return !aPlayer.field_71075_bZ.field_75102_a;
    }

    public static boolean isRealPlayer(EntityLivingBase entity) {
        EntityPlayer p;
        return entity instanceof EntityPlayer && !(p = (EntityPlayer)entity).getClass().getName().contains("Fake");
    }
}

