/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload.recipes;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.loaders.postload.MachineRecipeLoader;
import net.minecraft.item.ItemStack;

public class CircuitAssemblerRecipes
implements Runnable {
    @Override
    public void run() {
        this.registerRailcraftRecipes();
        this.registerForestryRecipes();
    }

    public void registerRailcraftRecipes() {
        if (!Mods.Railcraft.isModLoaded()) {
            return;
        }
        for (Materials tMat : MachineRecipeLoader.solderingMats) {
            int tMultiplier = tMat.contains(SubTag.SOLDERING_MATERIAL_GOOD) ? 1 : (tMat.contains(SubTag.SOLDERING_MATERIAL_BAD) ? 4 : 2);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.LV, 1L), ItemList.Cover_Controller.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 4L, 0)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(300).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.LV, 1L), ItemList.Sensor_LV.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 4L, 1)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(300).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.LV, 1L), GTModHandler.getModItem(Mods.Railcraft.ID, "part.signal.lamp", 1L, 0)).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 4L, 2)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(300).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.MV, 1L), ItemList.Cover_Controller.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 8L, 0)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(400).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.MV, 1L), ItemList.Sensor_LV.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 8L, 1)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(400).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.MV, 1L), GTModHandler.getModItem(Mods.Railcraft.ID, "part.signal.lamp", 1L, 0)).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 8L, 2)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(400).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Epoxy_Advanced.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.HV, 1L), ItemList.Cover_Controller.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 16L, 0)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(500).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Epoxy_Advanced.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.HV, 1L), ItemList.Sensor_LV.get(1L, new Object[0])).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 16L, 1)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(500).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Epoxy_Advanced.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.HV, 1L), GTModHandler.getModItem(Mods.Railcraft.ID, "part.signal.lamp", 1L, 0)).itemOutputs(GTModHandler.getModItem(Mods.Railcraft.ID, "part.circuit", 16L, 2)).fluidInputs(tMat.getMolten(144L * (long)tMultiplier / 2L)).duration(500).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
        }
    }

    public void registerForestryRecipes() {
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, Materials.RedAlloy, 1L), GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Gold, 2L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Copper, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.AnnealedCopper, 2L)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "thermionicTubes", 4L, 0)).fluidInputs(Materials.Glass.getMolten(576L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, Materials.RedAlloy, 1L), GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Gold, 2L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Copper, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.WroughtIron, 2L)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "thermionicTubes", 4L, 3)).fluidInputs(Materials.Glass.getMolten(576L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
        ItemStack[] rodMaterials = new ItemStack[]{GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Copper, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Tin, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Bronze, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Iron, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Gold, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Diamond, 2L), GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LongObsidianRod", 2L, 0), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Blaze, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Rubber, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Emerald, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Apatite, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Lapis, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.EnderEye, 2L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Uranium, 2L)};
        for (int metaid = 0; metaid < rodMaterials.length; ++metaid) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, Materials.RedAlloy, 1L), GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Gold, 2L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Copper, 2L), rodMaterials[metaid]).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "thermionicTubes", 4L, metaid)).fluidInputs(Materials.Glass.getMolten(576L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
        }
        for (Materials tMat : MachineRecipeLoader.solderingMats) {
            int tMultiplier = tMat.contains(SubTag.SOLDERING_MATERIAL_GOOD) ? 1 : (tMat.contains(SubTag.SOLDERING_MATERIAL_BAD) ? 4 : 2);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.ULV, 2L), GTOreDictUnificator.get(OrePrefixes.foil, Materials.Iron, 2L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Iron, 4L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Iron, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "chipsets", 1L, 0)).fluidInputs(tMat.getMolten(1152L * (long)tMultiplier / 2L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.LV, 2L), GTOreDictUnificator.get(OrePrefixes.foil, Materials.Bronze, 2L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Bronze, 4L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Bronze, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "chipsets", 1L, 1)).fluidInputs(tMat.getMolten(1152L * (long)tMultiplier / 2L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.MV, 2L), GTOreDictUnificator.get(OrePrefixes.foil, Materials.Steel, 2L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Steel, 4L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Steel, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "chipsets", 1L, 2)).fluidInputs(tMat.getMolten(1152L * (long)tMultiplier / 2L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.circuit, Materials.HV, 2L), GTOreDictUnificator.get(OrePrefixes.foil, Materials.Electrum, 2L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Electrum, 4L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Electrum, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTModHandler.getModItem(Mods.Forestry.ID, "chipsets", 1L, 3)).fluidInputs(tMat.getMolten(1152L * (long)tMultiplier / 2L)).duration(200).eut((int)TierEU.RECIPE_LV).addTo(RecipeMaps.circuitAssemblerRecipes);
        }
    }
}

