/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.common.items.behaviors.BehaviourSense;
import gregtech.common.tools.GTTool;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class ToolSense
extends GTTool {
    private final ThreadLocal<Object> sIsHarvestingRightNow = new ThreadLocal();

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 4.0f;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "sense", "scythe") || GTToolHarvestHelper.isAppropriateMaterial(aBlock, Material.field_151585_k, Material.field_151584_j);
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World worldObj, int aX, int aY, int aZ) {
        if (aPlayer != null && aPlayer.func_70093_af()) {
            return aDefault / 2.0f;
        }
        return super.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, worldObj, aX, aY, aZ);
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rConversions = 0;
        if (this.sIsHarvestingRightNow.get() == null && aPlayer instanceof EntityPlayerMP) {
            this.sIsHarvestingRightNow.set(this);
            if (!aPlayer.func_70093_af()) {
                for (int i = -2; i < 3; ++i) {
                    for (int j = -2; j < 3; ++j) {
                        for (int k = -2; k < 3; ++k) {
                            if (i == 0 && j == 0 && k == 0 || !(aStack.func_77973_b().getDigSpeed(aStack, aPlayer.field_70170_p.func_147439_a(aX + i, aY + j, aZ + k), aPlayer.field_70170_p.func_72805_g(aX + i, aY + j, aZ + k)) > 0.0f) || !((EntityPlayerMP)aPlayer).field_71134_c.func_73084_b(aX + i, aY + j, aZ + k)) continue;
                            ++rConversions;
                        }
                    }
                }
            }
            this.sIsHarvestingRightNow.set(null);
        }
        return rConversions;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.toolHeadSense.mTextureIndex] : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.stick.mTextureIndex];
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviourSense(this.getToolDamagePerBlockBreak()));
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE + " has taken the Soul of " + EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

