/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.compressor;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.items.MetaGeneratedItem01;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.render.TileEntityBlackhole;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tectech.thing.metaTileEntity.multi.base.SoundLoopAnyBlock;

public class MTEBlackHoleCompressor
extends MTEExtendedPowerMultiBlockBase<MTEBlackHoleCompressor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEBlackHoleCompressor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "             CCC   CCC             ", "            CCC     CCC            ", "         CCCCC       CCCCC         ", "         CCCC         CCCC         ", "                                   ", "                                   ", "                                   ", "         CCCC         CCCC         ", "         CCCCC       CCCCC         ", "            CCC     CCC            ", "             CCC   CCC             ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "             CCC   CCC             ", "             CCC   CCC             ", "            CCCC   CCCC            ", "           CCCCC   CCCCC           ", "         CCCCCC     CCCCCC         ", "       CCCCCCC       CCCCCCC       ", "       CCCCCC         CCCCCC       ", "                                   ", "                                   ", "                                   ", "       CCCCCC         CCCCCC       ", "       CCCCCCC       CCCCCCC       ", "         CCCCCC     CCCCCC         ", "           CCCCC   CCCCC           ", "            CCCC   CCCC            ", "             CCC   CCC             ", "             CCC   CCC             ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCB     BCCCCCCB       ", "      CCCCCCCB       BCCCCCCC      ", "      CCCCCCB   BBB   BCCCCCC      ", "      BCCCCCB  B   B  BCCCCCB      ", "      BCCCCCB  B   B  BCCCCCB      ", "      BCCCCCB  B   B  BCCCCCB      ", "      CCCCCCB   BBB   BCCCCCC      ", "      CCCCCCCB       BCCCCCCC      ", "       BCCCCCCB     BCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCBCCCCCBCCCCCCB       ", "     CCCCCCCCBCCCCCCCBCCCCCCCC     ", "     CCCCCCCBCCCCCCCCCBCCCCCCC     ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "     CCCCCCCBCCCCCCCCCBCCCCCCC     ", "     CCCCCCCCBCCCCCCCBCCCCCCCC     ", "       BCCCCCCBCCCCCBCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCB     BCCCCCCB       ", "    CCCCCCCCCB       BCCCCCCCCC    ", "    CCCCCCCCB         BCCCCCCCC    ", "     DBCCCCCB         BCCCCCBD     ", "     DBCCCCCB         BCCCCCBD     ", "     DBCCCCCB         BCCCCCBD     ", "    CCCCCCCCB         BCCCCCCCC    ", "    CCCCCCCCCB       BCCCCCCCCC    ", "       BCCCCCCB     BCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "         BBBB  CCCCC  BBBB         ", "         BBBBCC     CCBBBB         ", "          BBC         CBB          ", "           C           C           ", "   CCC     C           C     CCC   ", "   CCC    C             C    CCC   ", "          C             C          ", "          C             C          ", "          C             C          ", "   CCC    C             C    CCC   ", "   CCC     C           C     CCC   ", "           C           C           ", "          BBC         CBB          ", "         BBBBCC     CCBBBB         ", "         BBBB  CCCCC  BBBB         ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "           BBB CCCCC BBB           ", "           BBCC     CCBB           ", "           BC         CB           ", "   CC       C         C       CC   ", "   CC      C           C      CC   ", "    D      C           C      D    ", "    D      C           C      D    ", "    D      C           C      D    ", "   CC      C           C      CC   ", "   CC       C         C       CC   ", "           BC         CB           ", "           BBCC     CCBB           ", "           BBB CCCCC BBB           ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBBCCCCCBBB            ", "            BBC     CBB            ", "  CCC       BC       CB       CCC  ", "  CCC       C         C       CCC  ", "            C         C            ", "            C         C            ", "            C         C            ", "  CCC       C         C       CCC  ", "  CCC       BC       CB       CCC  ", "            BBC     CBB            ", "            BBBCCCCCBBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             BBCCCCCBB             ", "  CC         BC     CB         CC  ", "  CC         C       C         CC  ", "   D         C       C         D   ", "   D         C       C         D   ", "   D         C       C         D   ", "  CC         C       C         CC  ", "  CC         BC     CB         CC  ", "             BBCCCCCBB             ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              BCCCCCB              ", "  CC         BC     CB         CC  ", "  CC         C       C         CC  ", "             C       C             ", "             C       C             ", "             C       C             ", "  CC         C       C         CC  ", "  CC         BC     CB         CC  ", "              BCCCCCB              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CCC          BBCCCBB          CCC ", " CCC          BC   CB          CCC ", "  D           C     C           D  ", "  D           C     C           D  ", "  D           C     C           D  ", " CCC          BC   CB          CCC ", " CCC          BBCCCBB          CCC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   "}, {"                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC            BCCCB            CC ", " CC           BC   CB           CC ", "              C     C              ", "              C     C              ", "              C     C              ", " CC           BC   CB           CC ", " CC            BCCCB            CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   "}, {"                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC             BBB             CC ", " CC            BCCCB            CC ", " D            BCCCCCB            D ", " D            BCCCCCB            D ", " D            BCCCCCB            D ", " CC            BCCCB            CC ", " CC             BBB             CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   "}, {"                                   ", "              CC   CC              ", "              CCBBBCC              ", "                CCC                ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC                             CC ", " CC             BBB             CC ", "  BC           B   B           CB  ", "  BC           B   B           CB  ", "  BC           B   B           CB  ", " CC             BBB             CC ", " CC                             CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                CCC                ", "              CCBBBCC              ", "              CC   CC              ", "                                   "}, {"              CCDDDCC              ", "              CC   CC              ", "              CBBBBBC              ", "               C   C               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "CCC                             CCC", "CCBC                           CBCC", "D B                             B D", "D B                             B D", "D B                             B D", "CCBC                           CBCC", "CCC                             CCC", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               C   C               ", "              CBBBBBC              ", "              CC   CC              ", "              CCDDDCC              "}, {"              CC   CC              ", "              CCCCCCC              ", "              BBBBBBB              ", "              C ABA C              ", "                ABA                ", "                 A                 ", "                 A                 ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "CCBC                           CBCC", "CCB                             BCC", " CBAA                         AABC ", " CBBBAA                     AABBBC ", " CBAA                         AABC ", "CCB                             BCC", "CCBC                           CBCC", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                 A                 ", "                 A                 ", "                ABA                ", "              C ABA C              ", "              BBBBBBB              ", "              CCCCCCC              ", "              CC   CC              "}, {"              CC   CC              ", "              CCCECCC              ", "              BBBBBBB              ", "              C BBB C              ", "                BBB                ", "                ABA                ", "                ABA                ", "                 B                 ", "                 B                 ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "CCBC                           CBCC", "CCB                             BCC", " CBBBAA                     AABBBC ", " EBBBBBBB                 BBBBBBBE ", " CBBBAA                     AABBBC ", "CCB                             BCC", "CCBC                           CBCC", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                 B                 ", "                 B                 ", "                ABA                ", "                ABA                ", "                BBB                ", "              C BBB C              ", "              BBBBBBB              ", "              CCCECCC              ", "              CC   CC              "}, {"              CC   CC              ", "              CCCCCCC              ", "              BBBBBBB              ", "              C ABA C              ", "                ABA                ", "                 A                 ", "                 A                 ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "CCBC                           CBCC", "CCB                             BCC", " CBAA                         AABC ", " CBBBAA                     AABBBC ", " CBAA                         AABC ", "CCB                             BCC", "CCBC                           CBCC", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                 A                 ", "                 A                 ", "                ABA                ", "              C ABA C              ", "              BBBBBBB              ", "              CCCCCCC              ", "              CC   CC              "}, {"              CCDDDCC              ", "              CC   CC              ", "              CBBBBBC              ", "               C   C               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "CCC                             CCC", "CCBC                           CBCC", "D B                             B D", "D B                             B D", "D B                             B D", "CCBC                           CBCC", "CCC                             CCC", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               C   C               ", "              CBBBBBC              ", "              CC   CC              ", "              CCDDDCC              "}, {"                                   ", "              CC   CC              ", "              CCBBBCC              ", "                CCC                ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC                             CC ", " CC             BBB             CC ", "  BC           B   B           CB  ", "  BC           B   B           CB  ", "  BC           B   B           CB  ", " CC             BBB             CC ", " CC                             CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                CCC                ", "              CCBBBCC              ", "              CC   CC              ", "                                   "}, {"                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC             BBB             CC ", " CC            BCCCB            CC ", " D            BCCCCCB            D ", " D            BCCCCCB            D ", " D            BCCCCCB            D ", " CC            BCCCB            CC ", " CC             BBB             CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   "}, {"                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CC            BCCCB            CC ", " CC           BC   CB           CC ", "              C     C              ", "              C     C              ", "              C     C              ", " CC           BC   CB           CC ", " CC            BCCCB            CC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   "}, {"                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", " CCC          BBCCCBB          CCC ", " CCC          BC   CB          CCC ", "  D           C     C           D  ", "  D           C     C           D  ", "  D           C     C           D  ", " CCC          BC   CB          CCC ", " CCC          BBCCCBB          CCC ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              BCCCCCB              ", "  CC         BC     CB         CC  ", "  CC         C       C         CC  ", "             C       C             ", "             C       C             ", "             C       C             ", "  CC         C       C         CC  ", "  CC         BC     CB         CC  ", "              BCCCCCB              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "             BBCCCCCBB             ", "  CC         BC     CB         CC  ", "  CC         C       C         CC  ", "   D         C       C         D   ", "   D         C       C         D   ", "   D         C       C         D   ", "  CC         C       C         CC  ", "  CC         BC     CB         CC  ", "             BBCCCCCBB             ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBBCCCCCBBB            ", "            BBC     CBB            ", "  CCC       BC       CB       CCC  ", "  CCC       C         C       CCC  ", "            C         C            ", "            C         C            ", "            C         C            ", "  CCC       C         C       CCC  ", "  CCC       BC       CB       CCC  ", "            BBC     CBB            ", "            BBBCCCCCBBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "           BBB CCCCC BBB           ", "           BBCC     CCBB           ", "           BC         CB           ", "   CC       C         C       CC   ", "   CC      C           C      CC   ", "    D      C           C      D    ", "    D      C           C      D    ", "    D      C           C      D    ", "   CC      C           C      CC   ", "   CC       C         C       CC   ", "           BC         CB           ", "           BBCC     CCBB           ", "           BBB CCCCC BBB           ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "         BBBB  CC~CC  BBBB         ", "         BBBBCC     CCBBBB         ", "          BBC         CBB          ", "           C           C           ", "   CCC     C           C     CCC   ", "   CCC    C             C    CCC   ", "          C             C          ", "          C             C          ", "          C             C          ", "   CCC    C             C    CCC   ", "   CCC     C           C     CCC   ", "           C           C           ", "          BBC         CBB          ", "         BBBBCC     CCBBBB         ", "         BBBB  CCCCC  BBBB         ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCDDDCC              ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCB     BCCCCCCB       ", "    CCCCCCCCCB       BCCCCCCCCC    ", "    CCCCCCCCB         BCCCCCCCC    ", "     DBCCCCCB         BCCCCCBD     ", "     DBCCCCCB         BCCCCCBD     ", "     DBCCCCCB         BCCCCCBD     ", "    CCCCCCCCB         BCCCCCCCC    ", "    CCCCCCCCCB       BCCCCCCCCC    ", "       BCCCCCCB     BCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "              CCDDDCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCBCCCCCBCCCCCCB       ", "     CCCCCCCCBCCCCCCCBCCCCCCCC     ", "     CCCCCCCBCCCCCCCCCBCCCCCCC     ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "      BCCCCCBCCCCCCCCCBCCCCCB      ", "     CCCCCCCBCCCCCCCCCBCCCCCCC     ", "     CCCCCCCCBCCCCCCCBCCCCCCCC     ", "       BCCCCCCBCCCCCBCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CCBBBCC              ", "            BBCCCCCCCBB            ", "           BCCCCCCCCCCCB           ", "          BCCCCCCCCCCCCCB          ", "         BCCCCCCCCCCCCCCCB         ", "        BCCCCCCCCCCCCCCCCCB        ", "       BCCCCCCCBBBBBCCCCCCCB       ", "       BCCCCCCB     BCCCCCCB       ", "      CCCCCCCB       BCCCCCCC      ", "      CCCCCCB   BBB   BCCCCCC      ", "      BCCCCCB  B   B  BCCCCCB      ", "      BCCCCCB  B   B  BCCCCCB      ", "      BCCCCCB  B   B  BCCCCCB      ", "      CCCCCCB   BBB   BCCCCCC      ", "      CCCCCCCB       BCCCCCCC      ", "       BCCCCCCB     BCCCCCCB       ", "       BCCCCCCCBBBBBCCCCCCCB       ", "        BCCCCCCCCCCCCCCCCCB        ", "         BCCCCCCCCCCCCCCCB         ", "          BCCCCCCCCCCCCCB          ", "           BCCCCCCCCCCCB           ", "            BBCCCCCCCBB            ", "              CCBBBCC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "             CCC   CCC             ", "             CCC   CCC             ", "            CCCC   CCCC            ", "           CCCCC   CCCCC           ", "         CCCCCC     CCCCCC         ", "       CCCCCCC       CCCCCCC       ", "       CCCCCC         CCCCCC       ", "                                   ", "                                   ", "                                   ", "       CCCCCC         CCCCCC       ", "       CCCCCCC       CCCCCCC       ", "         CCCCCC     CCCCCC         ", "           CCCCC   CCCCC           ", "            CCCC   CCCC            ", "             CCC   CCC             ", "             CCC   CCC             ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "             CCC   CCC             ", "            CCC     CCC            ", "         CCCCC       CCCCC         ", "         CCCC         CCCC         ", "                                   ", "                                   ", "                                   ", "         CCCC         CCCC         ", "         CCCCC       CCCCC         ", "            CCC     CCC            ", "             CCC   CCC             ", "              CC   CC              ", "              CC   CC              ", "              CC   CC              ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)4)).addElement('B', GTStructureUtility.buildHatchAdder(MTEBlackHoleCompressor.class).atLeast(HatchElement.Energy.or(HatchElement.ExoticEnergy), HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(12)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEBlackHoleCompressor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)12)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)11)).addElement('D', GTStructureUtility.ofFrame(Materials.NaquadahAlloy)).addElement('E', GTStructureUtility.buildHatchAdder(MTEBlackHoleCompressor.class).atLeast(HatchElement.InputHatch).adder(MTEBlackHoleCompressor::addSpacetimeInput).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(11)).dot(2).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)11))).build();
    private int catalyzingCounter = 0;
    private float blackHoleStability = 100.0f;
    private final ArrayList<MTEHatchInput> spacetimeHatches = new ArrayList();
    private byte blackHoleStatus = 1;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopAnyBlock blackholeSoundLoop;
    private final FluidStack blackholeCatalyzingCost = MaterialsUEVplus.SpaceTime.getMolten(1L);
    private int catalyzingCostModifier = 1;
    private int mCasingAmount;
    private int collapseTimer = -1;
    private static final int MACHINEMODE_COMPRESSOR = 0;
    private static final int MACHINEMODE_BLACKHOLE = 1;
    private boolean shouldRender = true;
    private TileEntityBlackhole rendererTileEntity = null;

    public MTEBlackHoleCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEBlackHoleCompressor(String aName) {
        super(aName);
    }

    private boolean addSpacetimeInput(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity iMetaTileEntity;
        if (aTileEntity != null && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchInput) {
            MTEHatchInput hatch = (MTEHatchInput)iMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            this.spacetimeHatches.add(hatch);
            return true;
        }
        return false;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public IStructureDefinition<MTEBlackHoleCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBlackHoleCompressor(this.mName);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.shouldRender = !this.shouldRender;
        if (!this.shouldRender) {
            PlayerUtils.messagePlayer(aPlayer, "Rendering off");
            this.rendererTileEntity = null;
            this.destroyRenderBlock();
        } else {
            if (this.blackHoleStatus != 1) {
                this.createRenderBlock();
            }
            PlayerUtils.messagePlayer(aPlayer, "Rendering on");
        }
    }

    @Override
    public void onValueUpdate(byte aValue) {
        byte oBlackHoleStatus = this.blackHoleStatus;
        this.blackHoleStatus = aValue;
        if (oBlackHoleStatus != this.blackHoleStatus) {
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playBlackHoleSounds() {
        if (this.blackHoleStatus > 1) {
            if (this.blackholeSoundLoop == null) {
                int z;
                int y;
                ForgeDirection oppositeDirection = this.getDirection().getOpposite();
                int offsetX = 7 * oppositeDirection.offsetX;
                int offsetY = 11;
                int offsetZ = 7 * oppositeDirection.offsetZ;
                World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
                IGregTechTileEntity base = this.getBaseMetaTileEntity();
                int x = base.getXCoord() + offsetX;
                Block blockAtSoundLocation = world.func_147439_a(x, y = base.getYCoord() + offsetY, z = base.getZCoord() + offsetZ);
                if (blockAtSoundLocation == Blocks.field_150350_a) {
                    return;
                }
                int[] offset = new int[]{offsetX, offsetY, offsetZ};
                this.blackholeSoundLoop = new SoundLoopAnyBlock(SoundResource.GT_MACHINES_BLACK_HOLE_COMPRESSOR.resourceLocation, this.getBaseMetaTileEntity(), false, false, offset, Blocks.field_150350_a);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.blackholeSoundLoop);
            }
        } else if (this.blackholeSoundLoop != null) {
            this.blackholeSoundLoop = null;
        }
    }

    @Override
    public byte getUpdateData() {
        return this.blackHoleStatus;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture;
        if (side == aFacing) {
            Textures.BlockIcons GLOW_OVERLAY;
            Textures.BlockIcons MAIN_OVERLAY;
            switch (this.blackHoleStatus) {
                default: {
                    MAIN_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE;
                    GLOW_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE_GLOW;
                    break;
                }
                case 2: {
                    MAIN_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE_ACTIVE;
                    GLOW_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE_ACTIVE_GLOW;
                    break;
                }
                case 3: {
                    MAIN_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE_UNSTABLE;
                    GLOW_OVERLAY = Textures.BlockIcons.OVERLAY_MULTI_BLACKHOLE_UNSTABLE_GLOW;
                }
            }
            rTexture = new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 11)), TextureFactory.builder().addIcon(MAIN_OVERLAY).extFacing().build(), TextureFactory.builder().addIcon(GLOW_OVERLAY).extFacing().glow().build()};
        } else {
            rTexture = new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 11))};
        }
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Compressor, Advanced Neutronium Compressor").addInfo(EnumChatFormatting.LIGHT_PURPLE + "Uses the immense power of the event horizon to compress things").addInfo(EnumChatFormatting.LIGHT_PURPLE + "No longer requires heat management to perform superdense compression").addInfo(EnumChatFormatting.LIGHT_PURPLE + "Can create advanced singularities!").addSeparator().addInfo("Insert a " + EnumChatFormatting.WHITE + "Black Hole Seed" + EnumChatFormatting.GRAY + " to open a black hole").addInfo("The black hole will begin its life at " + EnumChatFormatting.RED + "100" + EnumChatFormatting.GRAY + " stability and slowly decay").addInfo("Stability decays by " + EnumChatFormatting.RED + "1/s" + EnumChatFormatting.GRAY + " until it reaches 0").addInfo("At 0 stability, the black hole is " + EnumChatFormatting.DARK_RED + "UNSTABLE").addInfo("Once the black hole becomes unstable, it will void recipes and eventually close itself!").addSeparator().addInfo("The decay can be " + EnumChatFormatting.BOLD + "halted" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " by inserting 1 L/s of spacetime into specific hatches").addInfo("Every " + EnumChatFormatting.RED + "30" + EnumChatFormatting.GRAY + " total seconds saved by spacetime insertion will " + EnumChatFormatting.RED + "double" + EnumChatFormatting.GRAY + " the cost per second!").addInfo("Insert a " + EnumChatFormatting.WHITE + "Black Hole Collapser" + EnumChatFormatting.GRAY + " to close the black hole").addInfo("To restore stability and reset spacetime costs, close the black hole and open a new one").addSeparator().addInfo(EnumChatFormatting.WHITE + "Use circuit 20 for Compressor and 21 for Neutronium Compressor").addInfo("400% faster than singleblock machines of the same voltage").addInfo("Only uses 70% of the EU/t normally required").addInfo("Gains 8 parallels per voltage tier").addInfo(EnumChatFormatting.RED + "2x/4x" + EnumChatFormatting.GRAY + " parallels when stability is BELOW " + EnumChatFormatting.RED + "50/20").addTecTechHatchInfo().addInfo(EnumChatFormatting.RED + "Recipe tier is limited to hatch tier + 1. Will not perform overclocks above the hatch tier.").beginStructureBlock(35, 33, 35, false).addCasingInfoMin("Background Radiation Absorbent Casing", 950, false).addCasingInfoExactly("Extreme Density Space-Bending Casing", 3667, false).addCasingInfoExactly("Hawking Radiation Realignment Focus", 64, false).addCasingInfoExactly("Naquadah Alloy Frame Box", 144, false).addInputHatch("Spacetime Insertion, Behind Laser", 2).addInputBus("Any Radiation Absorbent Casing", 1).addOutputBus("Any Radiation Absorbent Casing", 1).addInputHatch("Any Radiation Absorbent Casing", 1).addEnergyHatch("Any Radiation Absorbent Casing", 1).toolTipFinisher(GTValues.AuthorFourIsTheNumber, GTValues.Ollie, "BucketBrigade");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 17, 27, 10);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 17, 27, 10, realBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mEnergyHatches.clear();
        this.mExoticEnergyHatches.clear();
        this.spacetimeHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 17, 27, 10)) {
            return false;
        }
        return this.mCasingAmount >= 950;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("catalyzingCounter")) {
            this.catalyzingCounter = aNBT.func_74762_e("catalyzingCounter");
        }
        if (aNBT.func_74764_b("catalyzingCostModifier")) {
            this.catalyzingCostModifier = aNBT.func_74762_e("catalyzingCostModifier");
        }
        if (aNBT.func_74764_b("blackHoleStatus")) {
            this.blackHoleStatus = aNBT.func_74771_c("blackHoleStatus");
        }
        if (aNBT.func_74764_b("blackHoleStability")) {
            this.blackHoleStability = aNBT.func_74760_g("blackHoleStability");
        }
        if (aNBT.func_74764_b("shouldRender")) {
            this.shouldRender = aNBT.func_74767_n("shouldRender");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("catalyzingCounter", this.catalyzingCounter);
        aNBT.func_74768_a("catalyzingCostModifier", this.catalyzingCostModifier);
        aNBT.func_74774_a("blackHoleStatus", this.blackHoleStatus);
        aNBT.func_74776_a("blackHoleStability", this.blackHoleStability);
        aNBT.func_74757_a("shouldRender", this.shouldRender);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("parallels", this.getMaxParallelRecipes());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + tag.func_74762_e("parallels"));
    }

    private int getModeFromCircuit(ItemStack[] t) {
        for (ItemStack j : t) {
            if (j.func_77973_b() != GTUtility.getIntegratedCircuit(0).func_77973_b()) continue;
            if (j.func_77960_j() == 20) {
                return 0;
            }
            if (j.func_77960_j() > 21) continue;
            return 1;
        }
        return 0;
    }

    private void searchAndDecrementCatalysts() {
        for (MTEHatchInputBus bus : GTUtility.filterValidMTEs(this.mInputBusses)) {
            for (int i = 0; i < bus.func_70302_i_(); ++i) {
                ItemStack inputItem = bus.func_70301_a(i);
                if (inputItem == null || !(inputItem.func_77973_b() instanceof MetaGeneratedItem01)) continue;
                if (inputItem.func_77960_j() == 32418 && this.blackHoleStatus == 1) {
                    bus.func_70298_a(i, 1);
                    if (bus instanceof IRecipeProcessingAwareHatch) {
                        IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)bus);
                        this.setResultIfFailure(aware.endRecipeProcessing(this));
                        aware.startRecipeProcessing();
                    }
                    this.blackHoleStatus = (byte)2;
                    this.createRenderBlock();
                    return;
                }
                if (inputItem.func_77960_j() != 32419 || this.blackHoleStatus == 1) continue;
                bus.func_70298_a(i, 1);
                if (bus instanceof IRecipeProcessingAwareHatch) {
                    IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)bus);
                    this.setResultIfFailure(aware.endRecipeProcessing(this));
                    aware.startRecipeProcessing();
                }
                this.blackHoleStatus = 1;
                this.blackHoleStability = 100.0f;
                this.catalyzingCostModifier = 1;
                this.catalyzingCounter = 0;
                if (this.rendererTileEntity != null) {
                    this.rendererTileEntity.startScaleChange(false);
                }
                this.collapseTimer = 40;
                return;
            }
        }
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        this.searchAndDecrementCatalysts();
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                switch (MTEBlackHoleCompressor.this.getModeFromCircuit(this.inputItems)) {
                    case 0: {
                        return super.findRecipeMatches(RecipeMaps.compressorRecipes);
                    }
                    case 1: {
                        return super.findRecipeMatches(RecipeMaps.neutroniumCompressorRecipes);
                    }
                }
                return super.findRecipeMatches(null);
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                int ocs = GTUtility.getTier(MTEBlackHoleCompressor.this.getAverageInputVoltage()) - GTUtility.getTier(recipe.mEUt);
                if (ocs < 0) {
                    ocs = 0;
                }
                return super.createOverclockCalculator(recipe).limitOverclockCount(ocs);
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (MTEBlackHoleCompressor.this.blackHoleStatus == 1) {
                    return CheckRecipeResultRegistry.NO_BLACK_HOLE;
                }
                if (GTUtility.getTier(MTEBlackHoleCompressor.this.getAverageInputVoltage()) < GTUtility.getTier(recipe.mEUt) - 1) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes)).setEuModifier(0.7f)).setSpeedBonus(0.2f);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        if (this.mExoticEnergyHatches.isEmpty()) {
            logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
            logic.setAvailableAmperage(1L);
        } else {
            super.setProcessingLogicPower(logic);
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.blackHoleStatus != 2) {
            this.mOutputItems = null;
            this.mOutputFluids = null;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.collapseTimer != -1) {
            if (this.collapseTimer == 0) {
                this.destroyRenderBlock();
            }
            --this.collapseTimer;
        }
        if (!aBaseMetaTileEntity.isServerSide()) {
            this.playBlackHoleSounds();
            return;
        }
        if (this.blackHoleStatus == 1 || aTick % 20L != 0L) {
            return;
        }
        float stabilityDecrease = 1.0f;
        boolean didDrain = false;
        if (this.blackHoleStability >= 0.0f) {
            FluidStack totalCost = new FluidStack(this.blackholeCatalyzingCost, this.catalyzingCostModifier);
            for (MTEHatchInput hatch : this.spacetimeHatches) {
                if (!this.drain(hatch, totalCost, false)) continue;
                this.drain(hatch, totalCost, true);
                ++this.catalyzingCounter;
                stabilityDecrease = 0.0f;
                if (this.catalyzingCounter >= 30) {
                    if (this.catalyzingCostModifier <= 1000000000) {
                        this.catalyzingCostModifier *= 2;
                    }
                    this.catalyzingCounter = 0;
                }
                didDrain = true;
                break;
            }
        } else {
            this.blackHoleStatus = (byte)3;
        }
        if (this.shouldRender && (this.rendererTileEntity != null || this.createRenderBlock())) {
            this.rendererTileEntity.toggleLaser(didDrain);
            this.rendererTileEntity.setStability(Math.max(0.0f, this.blackHoleStability / 100.0f));
        }
        this.blackHoleStability -= stabilityDecrease;
        if (this.blackHoleStability <= -900.0f) {
            this.blackHoleStatus = 1;
            this.blackHoleStability = 100.0f;
            this.catalyzingCostModifier = 1;
            this.rendererTileEntity = null;
            this.destroyRenderBlock();
        }
    }

    public int getMaxParallelRecipes() {
        int parallels = 8 * GTUtility.getTier(this.getMaxInputVoltage());
        if (this.blackHoleStability < 60.0f) {
            parallels *= 2;
            if (this.blackHoleStability < 20.0f) {
                parallels *= 2;
            }
        }
        return parallels;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.compressorRecipes, RecipeMaps.neutroniumCompressorRecipes);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d != ForgeDirection.UP && d != ForgeDirection.DOWN;
    }

    @Override
    public void onBlockDestroyed() {
        this.destroyRenderBlock();
        super.onBlockDestroyed();
    }

    public boolean isRotationChangeAllowed() {
        return false;
    }

    private boolean createRenderBlock() {
        if (!this.shouldRender || !this.mMachine) {
            return false;
        }
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        ForgeDirection opposite = this.getDirection().getOpposite();
        int x = 7 * opposite.offsetX;
        int z = 7 * opposite.offsetZ;
        int y = 11;
        base.getWorld().func_147449_b(base.getXCoord() + x, base.getYCoord() + y, base.getZCoord() + z, Blocks.field_150350_a);
        base.getWorld().func_147449_b(base.getXCoord() + x, base.getYCoord() + y, base.getZCoord() + z, GregTechAPI.sBlackholeRender);
        this.rendererTileEntity = (TileEntityBlackhole)base.getWorld().func_147438_o(base.getXCoord() + x, base.getYCoord() + y, base.getZCoord() + z);
        this.rendererTileEntity.startScaleChange(true);
        this.rendererTileEntity.setStability(this.blackHoleStability / 100.0f);
        return true;
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        ForgeDirection opposite = this.getDirection().getOpposite();
        int x = 7 * opposite.offsetX;
        int z = 7 * opposite.offsetZ;
        int y = 11;
        this.getBaseMetaTileEntity().getWorld().func_147449_b(base.getXCoord() + x, base.getYCoord() + y, base.getZCoord() + z, Blocks.field_150350_a);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

