/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTELargeChemicalReactor
extends MTEEnhancedMultiBlockBase<MTELargeChemicalReactor>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 176;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTELargeChemicalReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cxc", "ccc"}, {"c~c", "xPx", "cxc"}, {"ccc", "cxc", "ccc"}})).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('c', GTStructureUtility.buildHatchAdder(MTELargeChemicalReactor.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(176).dot(1).buildAndChain(StructureUtility.onElementPass(MTELargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)))).addElement('x', GTStructureUtility.buildHatchAdder(MTELargeChemicalReactor.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(176).dot(1).buildAndChain(CoilStructureElement.INSTANCE, StructureUtility.onElementPass(MTELargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)))).build();
    private int mCasingAmount;
    private int mCoilAmount;

    public MTELargeChemicalReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeChemicalReactor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeChemicalReactor(this.mName);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Chemical Reactor, LCR").addInfo("Does not lose efficiency when overclocked").addInfo("Accepts fluids instead of fluid cells").beginStructureBlock(3, 3, 3, false).addController("Front center").addCasingInfoRange("Chemically Inert Machine Casing", 8, 22, false).addOtherStructurePart("PTFE Pipe Machine Casing", "Center").addOtherStructurePart("Heating Coil", "Adjacent to the PTFE Pipe Machine Casing", 1).addEnergyHatch("Any casing", 1, 2).addMaintenanceHatch("Any casing", 1, 2).addInputBus("Any casing", 1, 2).addInputHatch("Any casing", 1, 2).addOutputBus("Any casing", 1, 2).addOutputHatch("Any casing", 1, 2).addStructureInfo("You can have multiple hatches/busses").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.multiblockChemicalReactorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic().enablePerfectOverclock();
    }

    @Override
    public IStructureDefinition<MTELargeChemicalReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mCoilAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0) && this.mCasingAmount >= 8 && this.mCoilAmount == 1 && !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.mCoilAmount = 0;
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.mCoilAmount = 0;
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    private static enum CoilStructureElement implements IStructureElement<MTELargeChemicalReactor>
    {
        INSTANCE;


        public boolean check(MTELargeChemicalReactor t, World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof IHeatingCoil && ((IHeatingCoil)block).getCoilHeat(world.func_72805_g(x, y, z)) != HeatingCoilLevel.None) {
                return t.mCoilAmount++ == 0;
            }
            return false;
        }

        public boolean spawnHint(MTELargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTechAPI.sBlockCasings5, (int)0);
            return true;
        }

        public boolean placeBlock(MTELargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger) {
            if (t.mCoilAmount > 0) {
                return false;
            }
            boolean b = world.func_147465_d(x, y, z, GregTechAPI.sBlockCasings5, 0, 3);
            if (b) {
                t.mCoilAmount++;
            }
            return b;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTELargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
            return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(MTELargeChemicalReactor gt_metaTileEntity_largeChemicalReactor, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create((Iterable)IntStream.range(0, 8).mapToObj(i -> new ItemStack(GregTechAPI.sBlockCasings5, 1, i)).collect(Collectors.toList()));
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTELargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (t.mCoilAmount > 0) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            ItemStack result = env.getSource().takeOne((Predicate)ItemStackPredicate.from((Block)GregTechAPI.sBlockCasings5), true);
            if (result == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            IStructureElement.PlaceResult ret = StructureUtility.survivalPlaceBlock((ItemStack)result, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            if (ret == IStructureElement.PlaceResult.ACCEPT) {
                t.mCoilAmount++;
            }
            return ret;
        }
    }
}

