/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.misc.DrillingLogicDelegate;
import gregtech.common.misc.IDrillingLogicDelegateOwner;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMiner
extends MTEBasicMachine
implements IDrillingLogicDelegateOwner,
IAddUIWidgets {
    static final int[] RADIUS = new int[]{8, 8, 16, 24, 32};
    static final int[] SPEED = new int[]{160, 160, 80, 40, 20};
    static final int[] ENERGY = new int[]{8, 8, 32, 128, 512};
    private int radiusConfig;
    private final ArrayList<ChunkPosition> oreBlockPositions = new ArrayList();
    private final DrillingLogicDelegate pipe = new DrillingLogicDelegate(this);
    private final int mSpeed;
    private static final FallbackableUITexture progressBarTexture = GTUITextures.fallbackableProgressbar("miner", GTUITextures.PROGRESSBAR_CANNER);

    public MTEMiner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Digging ore instead of you", "Use Screwdriver to regulate work area", "Use Soft Mallet to disable and retract the pipe", String.format("%d EU/t, %d sec per block, no stuttering", ENERGY[aTier], SPEED[aTier] / 20), String.format("Maximum work area %dx%d", RADIUS[aTier] * 2 + 1, RADIUS[aTier] * 2 + 1), String.format("Fortune bonus of %d", aTier)}, 2, 2, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM_GLOW")).glow().build()));
        this.mSpeed = SPEED[aTier];
        this.radiusConfig = RADIUS[this.mTier];
    }

    public MTEMiner(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 2);
        this.mSpeed = SPEED[aTier];
        this.radiusConfig = RADIUS[this.mTier];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMiner(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.pipe.findTipDepth();
        this.fillOreList(aBaseMetaTileEntity);
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && aStack.func_77973_b() == DrillingLogicDelegate.MINING_PIPE_STACK.func_77973_b();
    }

    public boolean hasFreeSpace() {
        for (int i = this.getOutputSlot(); i < this.getOutputSlot() + 2; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        if (side != this.getBaseMetaTileEntity().getFrontFacing() && side != this.mMainFacing) {
            if (aPlayer.func_70093_af()) {
                if (this.radiusConfig >= 0) {
                    --this.radiusConfig;
                }
                if (this.radiusConfig < 0) {
                    this.radiusConfig = RADIUS[this.mTier];
                }
            } else {
                if (this.radiusConfig <= RADIUS[this.mTier]) {
                    ++this.radiusConfig;
                }
                if (this.radiusConfig > RADIUS[this.mTier]) {
                    this.radiusConfig = 0;
                }
            }
            GTUtility.sendChatToPlayer(aPlayer, String.format("%s %dx%d", StatCollector.func_74838_a((String)"GT5U.machines.workareaset"), this.radiusConfig * 2 + 1, this.radiusConfig * 2 + 1));
            this.fillOreList(this.getBaseMetaTileEntity());
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        this.pipe.onOwnerPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            this.mMaxProgresstime = 0;
            if (GTValues.debugBlockMiner) {
                GTLog.out.println("MINER: Disabled");
            }
            return;
        }
        if (!this.hasFreeSpace()) {
            this.mMaxProgresstime = 0;
            if (GTValues.debugBlockMiner) {
                GTLog.out.println("MINER: No free space");
            }
            return;
        }
        if (!aBaseMetaTileEntity.isUniversalEnergyStored((long)ENERGY[this.mTier] * (long)(this.mSpeed - this.mProgresstime))) {
            this.mMaxProgresstime = 0;
            if (GTValues.debugBlockMiner) {
                GTLog.out.println("MINER: Not enough energy yet, want " + ENERGY[this.mTier] * this.mSpeed + " have " + aBaseMetaTileEntity.getUniversalEnergyStored());
            }
            return;
        }
        if (!this.pipe.canContinueDrilling(aTick)) {
            this.mMaxProgresstime = 0;
            return;
        }
        this.mMaxProgresstime = this.mSpeed;
        aBaseMetaTileEntity.decreaseStoredEnergyUnits(ENERGY[this.mTier], true);
        if (this.mProgresstime == this.mSpeed - 1) {
            if (this.pipe.getTipDepth() == 0 || this.oreBlockPositions.isEmpty()) {
                boolean descends = this.pipe.descent(aBaseMetaTileEntity);
                if (descends) {
                    this.fillOreList(aBaseMetaTileEntity);
                }
            } else {
                int z;
                int y;
                int x;
                Block oreBlock;
                boolean isOre;
                do {
                    ChunkPosition oreBlockPos = this.oreBlockPositions.remove(0);
                    oreBlock = aBaseMetaTileEntity.getBlockOffset(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
                    x = aBaseMetaTileEntity.getXCoord() + oreBlockPos.field_151329_a;
                    y = aBaseMetaTileEntity.getYCoord() + oreBlockPos.field_151327_b;
                    z = aBaseMetaTileEntity.getZCoord() + oreBlockPos.field_151328_c;
                } while (!(isOre = GTUtility.isOre(oreBlock, aBaseMetaTileEntity.getWorld().func_72805_g(x, y, z))) && !this.oreBlockPositions.isEmpty());
                if (isOre) {
                    this.pipe.mineBlock(aBaseMetaTileEntity, oreBlock, x, y, z);
                }
            }
        }
    }

    private void fillOreList(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.pipe.getTipDepth() == 0) {
            return;
        }
        this.oreBlockPositions.clear();
        for (int z = -this.radiusConfig; z <= this.radiusConfig; ++z) {
            for (int x = -this.radiusConfig; x <= this.radiusConfig; ++x) {
                Block block = aBaseMetaTileEntity.getBlockOffset(x, this.pipe.getTipDepth(), z);
                byte blockMeta = aBaseMetaTileEntity.getMetaIDOffset(x, this.pipe.getTipDepth(), z);
                if (block instanceof BlockOresAbstract) {
                    TileEntity oreEntity = aBaseMetaTileEntity.getTileEntityOffset(x, this.pipe.getTipDepth(), z);
                    if (!(oreEntity instanceof TileEntityOres) || !((TileEntityOres)oreEntity).mNatural) continue;
                    this.oreBlockPositions.add(new ChunkPosition(x, this.pipe.getTipDepth(), z));
                    continue;
                }
                if (!GTUtility.isOre(block, blockMeta)) continue;
                this.oreBlockPositions.add(new ChunkPosition(x, this.pipe.getTipDepth(), z));
            }
        }
    }

    @Override
    public boolean pullInputs(Item item, int count, boolean simulate) {
        for (int i = 0; i < this.mInputSlotCount; ++i) {
            ItemStack stack = this.getInputAt(i);
            if (stack == null || stack.func_77973_b() != item || stack.field_77994_a < count) continue;
            if (simulate) {
                return true;
            }
            stack.field_77994_a -= count;
            if (stack.field_77994_a == 0) {
                this.mInventory[this.getInputSlot() + i] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pushOutputs(ItemStack stack, int count, boolean simulate, boolean allowInputSlots) {
        return allowInputSlots && this.pushOutput(this.getInputSlot(), this.getInputSlot() + this.mInputSlotCount, stack, count, simulate) || this.pushOutput(this.getOutputSlot(), this.getOutputSlot() + this.mOutputItems.length, stack, count, simulate);
    }

    private boolean pushOutput(int startIndex, int endIndex, ItemStack stack, int count, boolean simulate) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack slot = this.mInventory[i];
            if (slot == null || slot.field_77994_a == 0) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = count;
                    this.mInventory[i] = copy;
                }
                return true;
            }
            if (!GTUtility.areStacksEqual(slot, stack) || slot.field_77994_a > slot.func_77976_d() - count) continue;
            if (!simulate) {
                slot.field_77994_a += count;
            }
            return true;
        }
        return false;
    }

    @Override
    public long maxEUStore() {
        return Math.max(GTValues.V[this.mTier] * 64L, 4096L);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.radiusConfig != RADIUS[this.mTier]) {
            aNBT.func_74768_a("radiusConfig", this.radiusConfig);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int newRadius;
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("radiusConfig") && RADIUS[this.mTier] <= (newRadius = aNBT.func_74762_e("radiusConfig")) && newRadius > 0) {
            this.radiusConfig = newRadius;
        }
    }

    @Override
    public String[] getInfoData() {
        return new String[]{String.format("%s%s%s", EnumChatFormatting.BLUE, StatCollector.func_74838_a((String)"GT5U.machines.miner"), EnumChatFormatting.RESET), String.format("%s: %s%d%s %s", StatCollector.func_74838_a((String)"GT5U.machines.workarea"), EnumChatFormatting.GREEN, this.radiusConfig * 2 + 1, EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.blocks"))};
    }

    @Override
    public int getMachineTier() {
        return this.mTier;
    }

    @Override
    public int getMachineSpeed() {
        return this.mSpeed;
    }

    public DrillingLogicDelegate getPipe() {
        return this.pipe;
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(progressBarTexture).build();
    }
}

