/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.common.render.GTRenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class MetaGeneratedToolRenderer
implements IItemRenderer {
    public MetaGeneratedToolRenderer() {
        for (MetaGeneratedTool tItem : MetaGeneratedTool.sInstances.values()) {
            if (tItem == null) continue;
            MinecraftForgeClient.registerItemRenderer((Item)tItem, (IItemRenderer)this);
        }
    }

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        IToolStats toolStats;
        MetaGeneratedTool item = (MetaGeneratedTool)stack.func_77973_b();
        GL11.glEnable((int)3042);
        GTRenderUtil.applyStandardItemTransform(type);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IToolStats iToolStats = toolStats = item != null ? item.getToolStats(stack) : null;
        if (toolStats != null) {
            MetaGeneratedToolRenderer.renderToolPart(type, stack, toolStats, false);
            MetaGeneratedToolRenderer.renderToolPart(type, stack, toolStats, true);
            if (type == IItemRenderer.ItemRenderType.INVENTORY && MetaGeneratedTool.getPrimaryMaterial(stack) != Materials._NULL) {
                IIconContainer iconContainer;
                if (GTMod.gregtechproxy.mRenderItemDurabilityBar) {
                    long damage = MetaGeneratedTool.getToolDamage(stack);
                    long maxDamage = MetaGeneratedTool.getToolMaxDamage(stack);
                    iconContainer = damage <= 0L ? Textures.ItemIcons.DURABILITY_BAR[8] : (damage >= maxDamage ? Textures.ItemIcons.DURABILITY_BAR[0] : Textures.ItemIcons.DURABILITY_BAR[(int)Math.max(0L, Math.min(7L, (maxDamage - damage) * 8L / maxDamage))]);
                    this.renderIcon(iconContainer);
                }
                if (GTMod.gregtechproxy.mRenderItemChargeBar) {
                    long tCharge;
                    Long[] stats = item.getElectricStats(stack);
                    iconContainer = stats != null && stats[3] < 0L ? ((tCharge = item.getRealCharge(stack)) <= 0L ? Textures.ItemIcons.ENERGY_BAR[0] : (tCharge >= stats[0] ? Textures.ItemIcons.ENERGY_BAR[8] : Textures.ItemIcons.ENERGY_BAR[7 - (int)Math.max(0L, Math.min(6L, (stats[0] - tCharge) * 7L / stats[0]))])) : null;
                    this.renderIcon(iconContainer);
                }
            }
        }
        GL11.glDisable((int)3042);
    }

    private void renderIcon(IIconContainer iconContainer) {
        if (iconContainer != null) {
            IIcon icon = iconContainer.getIcon();
            IIcon overlay = iconContainer.getOverlayIcon();
            if (icon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(iconContainer.getTextureFile());
                GL11.glBlendFunc((int)770, (int)771);
                GTRenderUtil.renderItemIcon(icon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            }
            if (overlay != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(iconContainer.getTextureFile());
                GL11.glBlendFunc((int)770, (int)771);
                GTRenderUtil.renderItemIcon(overlay, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            }
        }
    }

    private static void renderToolPart(IItemRenderer.ItemRenderType type, ItemStack stack, IToolStats toolStats, boolean isToolHead) {
        IIconContainer iconContainer = toolStats.getIcon(isToolHead, stack);
        if (iconContainer != null) {
            IIcon icon = iconContainer.getIcon();
            IIcon overlay = iconContainer.getOverlayIcon();
            if (icon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(iconContainer.getTextureFile());
                GL11.glBlendFunc((int)770, (int)771);
                short[] modulation = toolStats.getRGBa(isToolHead, stack);
                GL11.glColor3f((float)((float)modulation[0] / 255.0f), (float)((float)modulation[1] / 255.0f), (float)((float)modulation[2] / 255.0f));
                GTRenderUtil.renderItem(type, icon);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (overlay != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(iconContainer.getTextureFile());
                GL11.glBlendFunc((int)770, (int)771);
                GTRenderUtil.renderItem(type, overlay);
            }
        }
    }
}

