/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import codechicken.lib.math.MathHelper;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourLighter
extends BehaviourNone {
    private final ItemStack mEmptyLighter;
    private final ItemStack mUsedLighter;
    private final ItemStack mFullLighter;
    private final long mFuelAmount;
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.lighter.tooltip", "Can light things on Fire");
    private final String mTooltipUses = GTLanguageManager.addStringLocalization("gt.behaviour.lighter.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = GTLanguageManager.addStringLocalization("gt.behaviour.unstackable", "Not usable when stacked!");

    public BehaviourLighter(ItemStack aEmptyLighter, ItemStack aUsedLighter, ItemStack aFullLighter, long aFuelAmount) {
        this.mFullLighter = aFullLighter;
        this.mUsedLighter = aUsedLighter;
        this.mEmptyLighter = aEmptyLighter;
        this.mFuelAmount = aFuelAmount;
    }

    @Override
    public boolean onLeftClickEntity(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aPlayer.field_70170_p.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (aEntity instanceof EntityCreeper) {
            this.prepare(aStack);
            long tFuelAmount = GTUtility.ItemNBT.getLighterFuel(aStack);
            if (GTUtility.areStacksEqual(aStack, this.mUsedLighter, true)) {
                GTUtility.sendSoundToPlayers(aPlayer.field_70170_p, SoundResource.FIRE_IGNITE, 1.0f, 1.0f, MathHelper.floor_double((double)aEntity.field_70165_t), MathHelper.floor_double((double)aEntity.field_70163_u), MathHelper.floor_double((double)aEntity.field_70161_v));
                ((EntityCreeper)aEntity).func_146079_cb();
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    --tFuelAmount;
                }
                rOutput = true;
            }
            GTUtility.ItemNBT.setLighterFuel(aStack, tFuelAmount);
            if (tFuelAmount <= 0L) {
                this.useUp(aStack);
            }
        }
        return rOutput;
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!GTUtility.isBlockAir(aWorld, aX += side.offsetX, aY += side.offsetY, aZ += side.offsetZ) || !aPlayer.func_82247_a(aX, aY, aZ, side.ordinal(), aStack)) {
            return false;
        }
        this.prepare(aStack);
        long tFuelAmount = GTUtility.ItemNBT.getLighterFuel(aStack);
        if (GTUtility.areStacksEqual(aStack, this.mUsedLighter, true)) {
            GTUtility.sendSoundToPlayers(aWorld, SoundResource.FIRE_IGNITE, 1.0f, 1.0f, aX, aY, aZ);
            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                --tFuelAmount;
            }
            rOutput = true;
        }
        GTUtility.ItemNBT.setLighterFuel(aStack, tFuelAmount);
        if (tFuelAmount <= 0L) {
            this.useUp(aStack);
        }
        return rOutput;
    }

    private void prepare(ItemStack aStack) {
        if (GTUtility.areStacksEqual(aStack, this.mFullLighter, true)) {
            aStack.func_150996_a(this.mUsedLighter.func_77973_b());
            Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mUsedLighter));
            GTUtility.ItemNBT.setLighterFuel(aStack, this.mFuelAmount);
        }
    }

    private void useUp(ItemStack aStack) {
        if (this.mEmptyLighter == null) {
            --aStack.field_77994_a;
        } else {
            aStack.func_150996_a(this.mEmptyLighter.func_77973_b());
            Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mEmptyLighter));
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tFuelAmount = tNBT == null ? this.mFuelAmount : (GTUtility.areStacksEqual(aStack, this.mFullLighter, true) ? this.mFuelAmount : tNBT.func_74763_f("GT.LighterFuel"));
        aList.add(this.mTooltipUses + " " + tFuelAmount);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

