/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.items.GTGenericItem;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.tileentities.machines.basic.MTEBetterJukebox;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWirelessHeadphones
extends GTGenericItem
implements IBauble {
    public static final String NBTKEY_JUKEBOX_COORDINATES = "jukeboxCoords";

    public ItemWirelessHeadphones() {
        super("WirelessHeadphones", "Wireless Headphones", null);
        this.func_77625_d(1);
        ItemList.WirelessHeadphones.set(this);
    }

    @Override
    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        if (aStack == null) {
            return;
        }
        NBTTagCompound tag = aStack.func_77978_p();
        if (tag == null || !tag.func_150297_b(NBTKEY_JUKEBOX_COORDINATES, 8)) {
            aList.add(StatCollector.func_74838_a((String)"GT5U.machines.betterjukebox.headphonesunbound"));
        } else {
            aList.add(StatCollector.func_74838_a((String)"GT5U.machines.betterjukebox.headphonesbound"));
            aList.add(tag.func_74779_i(NBTKEY_JUKEBOX_COORDINATES));
        }
    }

    @Override
    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity pointedTe = world.func_147438_o(x, y, z);
        if (!(pointedTe instanceof BaseMetaTileEntity)) {
            return false;
        }
        BaseMetaTileEntity mte = (BaseMetaTileEntity)pointedTe;
        IMetaTileEntity iMetaTileEntity = mte.getMetaTileEntity();
        if (!(iMetaTileEntity instanceof MTEBetterJukebox)) {
            return false;
        }
        MTEBetterJukebox jukebox = (MTEBetterJukebox)iMetaTileEntity;
        UUID uuid = jukebox.jukeboxUuid;
        if (uuid == MTEBetterJukebox.UNSET_UUID) {
            return false;
        }
        if (!world.field_72995_K) {
            NBTTagCompound tag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
            tag.func_74772_a("jukeboxUUIDLow", uuid.getLeastSignificantBits());
            tag.func_74772_a("jukeboxUUIDHigh", uuid.getMostSignificantBits());
            tag.func_74778_a(NBTKEY_JUKEBOX_COORDINATES, String.format("(%d, %d, %d) @ %d", x, y, z, world.field_73011_w.field_76574_g));
            stack.func_77982_d(tag);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.betterjukebox.headphonesbound", new Object[0]));
        }
        return true;
    }

    public static UUID getBoundJukeboxUUID(ItemStack stack) {
        if (stack == null || stack.func_77978_p() == null) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_150297_b("jukeboxUUIDLow", 99) || !tag.func_150297_b("jukeboxUUIDHigh", 99)) {
            return null;
        }
        long idLow = tag.func_74763_f("jukeboxUUIDLow");
        long idHigh = tag.func_74763_f("jukeboxUUIDHigh");
        return new UUID(idHigh, idLow);
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.UNIVERSAL;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public void onEquipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public void onUnequipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public boolean canEquip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }
}

