/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.enums.Materials;
import gregtech.api.util.GTLanguageManager;
import org.apache.commons.lang3.text.WordUtils;

public enum DropType {
    OIL("oil", true),
    MUTAGEN("small mutagen catalyst", true),
    COOLANT("coolant", true),
    HOT_COOLANT("hot coolant", true),
    HYDRA("hydra blood", true),
    SNOW_QUEEN("snow queen blood", true),
    OXYGEN("oxygen", true),
    LAPIS("lapis coolant", true),
    ENDERGOO("ender goo", true);

    private static final int[][] colours;
    public boolean showInList;
    public Materials material;
    public int chance;
    private final String name;

    private DropType(String pName, boolean show) {
        this.name = pName;
        this.showInList = show;
    }

    public void setHidden() {
        this.showInList = false;
    }

    public String getName() {
        return GTLanguageManager.addStringLocalization("drop." + this.name, WordUtils.capitalize((String)this.name) + " Drop");
    }

    public int[] getColours() {
        return colours[this.ordinal()];
    }

    static {
        colours = new int[][]{{0x19191B, 0x303032}, {16761088, 65297}, {1331034, 2397346}, {0xC11F1F, 0xEBB9B9}, {8857654, 12063532}, {13639681, 10223640}, {13158, 26299}, {1517489, 36067}, {10487271, 0x161616}};
    }
}

