/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.covers.IControlsWorkCover;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverControlsWork
extends CoverBehavior
implements IControlsWorkCover {
    public CoverControlsWork(ITexture coverTexture) {
        super(coverTexture);
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (!this.makeSureOnlyOne(side, aTileEntity)) {
            return 0;
        }
        if (aTileEntity instanceof IMachineProgress) {
            IMachineProgress machine = (IMachineProgress)((Object)aTileEntity);
            if (aCoverVariable < 2) {
                if (aInputRedstone > 0 == (aCoverVariable == 0)) {
                    if (!machine.isAllowedToWork()) {
                        machine.enableWorking();
                    }
                } else if (machine.isAllowedToWork()) {
                    machine.disableWorking();
                }
                machine.setWorkDataValue(aInputRedstone);
            } else if (aCoverVariable == 2) {
                machine.disableWorking();
            } else {
                if (machine.wasShutdown() && machine.getLastShutDownReason().wasCritical()) {
                    machine.disableWorking();
                    if (!this.mPlayerNotified) {
                        EntityPlayer player;
                        EntityPlayer entityPlayer = player = this.lastPlayer == null ? null : (EntityPlayer)this.lastPlayer.get();
                        if (player != null) {
                            this.lastPlayer = null;
                            this.mPlayerNotified = true;
                            GTUtility.sendChatToPlayer(player, aTileEntity.func_145825_b() + "at " + String.format("(%d,%d,%d)", aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord()) + " shut down.");
                        }
                    }
                    return 2;
                }
                return 3 + this.doCoverThings(side, aInputRedstone, aCoverID, aCoverVariable - 3, aTileEntity, aTimer);
            }
        }
        return aCoverVariable;
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable.get() != 2;
    }

    @Override
    private boolean makeSureOnlyOne(ForgeDirection side, ICoverable aTileEntity) {
        return IControlsWorkCover.makeSureOnlyOne(side, aTileEntity);
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        if (aTileEntity instanceof IMachineProgress) {
            ((IMachineProgress)((Object)aTileEntity)).enableWorking();
            ((IMachineProgress)((Object)aTileEntity)).setWorkDataValue((byte)0);
        }
        return true;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 5) < 0) {
            aCoverVariable = 2;
        }
        if (aCoverVariable == 0) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("003", "Enable with Signal"));
        }
        if (aCoverVariable == 1) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("004", "Disable with Signal"));
        }
        if (aCoverVariable == 2) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("005", "Disabled"));
        }
        if (aCoverVariable == 3) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("505", "Enable with Signal (Safe)"));
        }
        if (aCoverVariable == 4) {
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("506", "Disable with Signal (Safe)"));
        }
        return aCoverVariable;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean isCoverPlaceable(ForgeDirection side, ItemStack aStack, ICoverable aTileEntity) {
        if (!super.isCoverPlaceable(side, aStack, aTileEntity)) {
            return false;
        }
        for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
            if (!(aTileEntity.getCoverBehaviorAtSideNew(tSide) instanceof IControlsWorkCover)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ControlsWorkUIFactory(buildContext).createWindow();
    }

    private class ControlsWorkUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public ControlsWorkUIFactory(CoverUIBuildContext buildContext) {
            super(CoverControlsWork.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverControlsWork.this, (id, coverData) -> !this.getClickable((int)id, CoverControlsWork.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, CoverControlsWork.convert(coverData)))).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_REDSTONE_ON).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_REDSTONE_OFF).setPos(0, 18)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CROSS).setPos(0, 36)).setPos(10, 25))).widget(new CoverDataControllerWidget<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverControlsWork.this).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofCheckAndCross(), coverData -> CoverControlsWork.convert(coverData) > 2, (coverData, state) -> new ISerializableObject.LegacyCoverData(this.adjustCoverVariable((boolean)state, CoverControlsWork.convert(coverData))), widget -> widget.setPos(0, 54)).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("243", "Enable with Redstone")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 29))).widget(new TextWidget(GTUtility.trans("244", "Disable with Redstone")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 47))).widget(new TextWidget(GTUtility.trans("245", "Disable machine")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 65))).widget(new TextWidget(GTUtility.trans("507", "Safe Mode")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 83));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            if (coverVariable > 2) {
                return id + 3;
            }
            return id;
        }

        private boolean getClickable(int id, int coverVariable) {
            return id != coverVariable && id != coverVariable - 3 || id == 3;
        }

        private int adjustCoverVariable(boolean safeMode, int coverVariable) {
            if (safeMode && coverVariable <= 2) {
                coverVariable += 3;
            }
            if (!safeMode && coverVariable > 2) {
                coverVariable -= 3;
            }
            return coverVariable;
        }
    }
}

