/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import codechicken.nei.api.API;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.blocks.BlockStorage;
import gregtech.common.blocks.ItemStorage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockMetal
extends BlockStorage {
    public Materials[] mMats;
    public OrePrefixes mPrefix;
    public IIconContainer[] mBlockIcons;
    public boolean mHideBlocks;
    public static boolean mNEIisLoaded = Mods.NotEnoughItems.isModLoaded();

    public BlockMetal(String aName, Materials[] aMats, OrePrefixes aPrefix, IIconContainer[] aBlockIcons) {
        super(ItemStorage.class, aName, Material.field_151573_f);
        int i;
        this.mMats = aMats;
        this.mPrefix = aPrefix;
        this.mBlockIcons = aBlockIcons;
        this.mHideBlocks = mNEIisLoaded;
        for (i = 0; i < aMats.length; ++i) {
            if (aMats[i].mMetaItemSubID <= 0 || !aMats[i].mHasParentMod) continue;
            GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + i + ".name", "Block of " + (GTLanguageManager.i18nPlaceholder ? "%material" : aMats[i].mDefaultLocalName));
            if (aPrefix.mIsUnificatable) {
                GTOreDictUnificator.set(aPrefix, aMats[i], new ItemStack((Block)this, 1, i));
                continue;
            }
            GTOreDictUnificator.registerOre(aPrefix.get(aMats[i]), new ItemStack((Block)this, 1, i));
        }
        if (aMats.length < 16 && mNEIisLoaded) {
            for (i = aMats.length; i < 16; ++i) {
                API.hideItem((ItemStack)new ItemStack((Block)this, 1, i));
            }
        }
    }

    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        if (aMeta >= 0 && aMeta < 16 && aMeta < this.mMats.length) {
            return this.mBlockIcons[aMeta].getIcon();
        }
        return null;
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        if (GregTechAPI.isMachineBlock(this, aWorld.func_72805_g(aX, aY, aZ))) {
            GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetaData) {
        if (GregTechAPI.isMachineBlock(this, aMetaData)) {
            GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }
}

