/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.metatileentity.MetaTileEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class ValidMTEList<E extends Collection<T>, T extends MetaTileEntity>
implements Iterable<T> {
    private final E collection;

    public ValidMTEList(E collection) {
        this.collection = collection;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ValidMTEIterator();
    }

    private class ValidMTEIterator
    implements Iterator<T> {
        Iterator<T> iterator;
        T nextObject;
        boolean nextObjectSet;

        private ValidMTEIterator() {
            this.iterator = ValidMTEList.this.collection.iterator();
            this.nextObject = null;
            this.nextObjectSet = false;
        }

        private boolean setNextObject() {
            while (this.iterator.hasNext()) {
                MetaTileEntity object = (MetaTileEntity)this.iterator.next();
                if (object != null && object.isValid()) {
                    this.nextObject = object;
                    this.nextObjectSet = true;
                    return true;
                }
                this.iterator.remove();
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextObjectSet || this.setNextObject();
        }

        @Override
        public T next() {
            if (!this.nextObjectSet && !this.setNextObject()) {
                throw new NoSuchElementException();
            }
            this.nextObjectSet = false;
            return this.nextObject;
        }
    }
}

