/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SemiFluidFuelHandler {
    public static boolean generateFuels() {
        FluidStack aCreosote = FluidUtils.getFluidStack("creosote", 1000);
        FluidStack aHeavyFuel = FluidUtils.getFluidStack("liquid_heavy_fuel", 1000);
        FluidStack aHeavyOil = FluidUtils.getFluidStack("liquid_heavy_oil", 1000);
        HashMap<Integer, Pair<FluidStack, Integer>> aFoundFluidsFromItems = new HashMap<Integer, Pair<FluidStack, Integer>>();
        for (GTRecipe r : RecipeMaps.denseLiquidFuels.getAllRecipes()) {
            GTRecipe g = r.copy();
            if (g != null && g.mEnabled && g.mInputs.length > 0 && g.mInputs[0] != null) {
                for (ItemStack i : g.mInputs) {
                    FluidStack f = FluidContainerRegistry.getFluidForFilledItem((ItemStack)i);
                    if (f == null) continue;
                    Pair<FluidStack, Integer> aData = new Pair<FluidStack, Integer>(f, g.mSpecialValue);
                    aFoundFluidsFromItems.put(aData.hashCode(), aData);
                }
                continue;
            }
            if (g == null || !g.mEnabled || g.mFluidInputs.length <= 0 || g.mFluidInputs[0] == null) continue;
            boolean aContainsCreosote = false;
            for (FluidStack f : g.mFluidInputs) {
                if (!f.isFluidEqual(aCreosote)) continue;
                aContainsCreosote = true;
            }
            g.mSpecialValue = g.mSpecialValue * (aContainsCreosote ? 6 : 3);
            Logger.INFO("Added " + g.mFluidInputs[0].getLocalizedName() + " to the Semi-Fluid Generator fuel map. Fuel Produces " + g.mSpecialValue + "EU per 1000L.");
            GTPPRecipeMaps.semiFluidFuels.add(g);
        }
        for (Pair p : aFoundFluidsFromItems.values()) {
            if (p == null) continue;
            int aFuelValue = (Integer)p.getValue();
            aFuelValue = ((FluidStack)p.getKey()).isFluidEqual(aCreosote) ? (aFuelValue *= 6) : (((FluidStack)p.getKey()).isFluidEqual(aHeavyFuel) || ((FluidStack)p.getKey()).isFluidEqual(aHeavyOil) ? (int)((double)aFuelValue * 1.5) : (aFuelValue *= 2));
            if (aFuelValue <= 384) {
                GTValues.RA.stdBuilder().fluidInputs((FluidStack)p.getKey()).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, aFuelValue).addTo(GTPPRecipeMaps.semiFluidFuels);
                Logger.INFO("Added " + ((FluidStack)p.getKey()).getLocalizedName() + " to the Semi-Fluid Generator fuel map. Fuel Produces " + aFuelValue * 1000 + "EU per 1000L.");
                continue;
            }
            Logger.INFO("Boosted Fuel value for " + ((FluidStack)p.getKey()).getLocalizedName() + " exceeds 512k, ignoring.");
        }
        return !GTPPRecipeMaps.semiFluidFuels.getAllRecipes().isEmpty();
    }
}

